/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.LabelService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.graphql.annotations.GraphQLProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/label")
@GraphQLProvider
@SendsAnalytics
@Tag(name="Label")
public class LabelResource {
    private final LabelService labelService;

    @Inject
    public LabelResource(@ComponentImport LabelService labelService) {
        this.labelService = labelService;
    }

    @Operation(summary="Get list of labels matching the given label name, namespace, space (via space key) or owner.", description="Returns a paginated list of labels matching the given label name, namespace, space (via space key) or owner.\nLeave query params empty to ignore.\n\nExample request URI(s):\n`http://example.com/confluence/rest/api/label/labels?spaceKey=MYS&namespace=global&limit=3`")
    @Parameters(value={@Parameter(name="labelName", description="The name of the label (excluding any prefix)", in=ParameterIn.QUERY), @Parameter(name="owner", description="The owner of the labels.", in=ParameterIn.QUERY), @Parameter(name="namespace", description="The namespace of the labels.", in=ParameterIn.QUERY), @Parameter(name="spaceKey", description="The spaceKey to restrict by.", in=ParameterIn.QUERY), @Parameter(name="limit", description="The limit of the number of labels to return, this may be restricted by fixed system limit.", in=ParameterIn.QUERY), @Parameter(name="start", description="The start point of the collection to return.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Return a list of labels matching the given request.", representation=Label.class, responseCode=200, paged=true), @ResponseDoc(documentation="Return a bad request error if the given label name is invalid", responseCode=400, restError=true), @ResponseDoc(documentation="Return a not found error if the given label name is not found", responseCode=404, restError=true)})
    @GET
    @Path(value="labels")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Label> labels(@QueryParam(value="labelName") String labelName, @QueryParam(value="owner") String owner, @QueryParam(value="namespace") String namespace, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.labelService.getLabelsByDetail((PageRequest)pageRequest, labelName, namespace, spaceKey, owner);
        return RestList.createRestList((PageRequest)pageRequest.copyWithLimits(labels), (PageResponse)labels);
    }

    @Operation(summary="Get related labels.", description="Return a paginated list of labels related to the given label name sorted by frequency of use in descending order.\nThe current process for identifying related labels solely\nexamines global labels, but it may change in the future.\n\nThe max number of labels that the API can respond with is limited, as we are filtering the access for each label.\nThis is set to 10000 by default but can be modified by the system property `confluence.rest.labels.related.max.to.process`.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/label/test_label_name/related`\n`https://example.com/confluence/rest/api/label/my:test_label_name/related?limit=200`")
    @Parameters(value={@Parameter(name="labelName", description="the name of the label (namespace prefixes permitted).", in=ParameterIn.PATH), @Parameter(name="limit", description="the maximum number of related labels to return. Default to be 100.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Return a JSON representation of related labels to the given label name", representation=Label.class, responseCode=200, paged=true), @ResponseDoc(documentation="Return a bad request error if the given label name is invalid", responseCode=400, restError=true), @ResponseDoc(documentation="Return a not found error if the given label name is not found", responseCode=404, restError=true)})
    @GET
    @Path(value="/{labelName}/related")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Label> related(@Context UriInfo uriInfo, @PathParam(value="labelName") String labelName, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.labelService.getRelatedLabels(labelName, (PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)labels).pageRequest((PageRequest)pageRequest.copyWithLimits(labels)).build();
    }

    @Operation(summary="Get recently used labels", description="Returns a paginated list of recently used labels within a Confluence instance. Labels are sorted\nfrom the most to the least recently used. Only global labels are considered in this list.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/label/recent`\n`https://example.com/confluence/rest/api/label/recent?start=2&limit=1`")
    @Parameters(value={@Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="a JSON representation of a list of labels, or an empty list if no labels are found.", responseCode=200, representation=Label.class, paged=true), @ResponseDoc(documentation="If the calling user does not have permission to retrieve recently used labels.", responseCode=403, restError=true)})
    @GET
    @Path(value="/recent")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Label> recent(@QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.labelService.getRecentlyUsedLabels((PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)labels).pageRequest((PageRequest)pageRequest.copyWithLimits(labels)).build();
    }

    @Operation(summary="Get most popular labels", description="Returns a paginated list of the most popular labels within a Confluence instance. This includes\nLabels used by Pages, Blog Posts, and other Content types. Labels are sorted\nbased on number of occurrences from the most to the least used. Only global labels are considered in this list.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/label/popular`\n`https://example.com/confluence/rest/api/label/popular?start=2&limit=1`")
    @Parameters(value={@Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="a JSON representation of a list of labels, or an empty list if no labels are found.", responseCode=200, representation=Label.class, paged=true), @ResponseDoc(documentation="If the calling user does not have permission to retrieve popular labels.", responseCode=403, restError=true)})
    @GET
    @Path(value="/popular")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Label> popular(@QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.labelService.getMostPopularLabels((PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)labels).pageRequest((PageRequest)pageRequest.copyWithLimits(labels)).build();
    }
}

