/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.api.model.longtasks.LongTaskStatus;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.longtasks.LongTaskService;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Optional;

@Path(value="/longtask")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Long Task")
public class LongTaskResource {
    private static final String DEFAULT_LIMIT = "100";
    private final LongTaskService longTaskService;

    @Inject
    public LongTaskResource(@ComponentImport LongTaskService longTaskService) {
        this.longTaskService = longTaskService;
    }

    @Operation(summary="Get tasks", description="Returns information about all tracked long-running tasks.")
    @Parameters(value={@Parameter(name="expand", description="comma separated list of properties to expand on the tasks.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDoc(documentation="returns a full JSON representation of a list of long tasks.", responseCode=200, representation=LongTaskStatus.class, paged=true)
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<LongTaskStatus> getTasks(@QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse response = this.longTaskService.getAll((PageRequest)pageRequest, expansions);
        return RestList.createRestList((PageRequest)pageRequest, (PageResponse)response);
    }

    @Operation(summary="Get task by ID", description="Returns information about a long-running task.")
    @Parameters(value={@Parameter(name="id", description=" the key of the task to be returned.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the task.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a full JSON representation of a long task.", responseCode=200, representation=LongTaskStatus.class), @ResponseDoc(documentation="Returned if there is no task with the given key, or if the calling user does not have permission to view it", responseCode=404, restError=true)})
    @GET
    @AnonymousSiteAccess
    @Path(value="/{id}")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public LongTaskStatus getTask(@PathParam(value="id") String idStr, @QueryParam(value="expand") @DefaultValue(value="") String expand) {
        LongTaskId id = LongTaskId.deserialise((String)idStr);
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        Optional task = this.longTaskService.getStatus(id, expansions);
        return (LongTaskStatus)task.orElseThrow(ServiceExceptionSupplier.notFound((String)("No task found with id : " + String.valueOf(id))));
    }

    public static Response submissionResponse(LongTaskSubmission taskSubmission) {
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)taskSubmission).build();
    }
}

