/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.plugins.restapi.graphql.GraphQLOffsetCursor;
import com.atlassian.confluence.rest.serialization.jackson2.SearchContextSerialization;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.graphql.annotations.GraphQLName;
import com.atlassian.graphql.annotations.GraphQLNonNull;
import com.atlassian.graphql.annotations.GraphQLProvider;
import com.atlassian.graphql.annotations.expansions.GraphQLExpansionParam;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@AnonymousSiteAccess
@LimitRequestSize
@SendsAnalytics
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/search")
@GraphQLProvider
@Tag(name="Search")
@PublicApi
public class SearchResource {
    private final CQLSearchService searchService;
    private final ObjectMapper mapper;

    @Inject
    public SearchResource(@ComponentImport CQLSearchService searchService, ObjectMapperProvider objectMapperProvider) {
        this.searchService = searchService;
        this.mapper = objectMapperProvider.getObjectMapper();
    }

    @Operation(summary="Search for entities in confluence", description="Search for entities in Confluence using the [Confluence Query Language (CQL)](https://developer.atlassian.com/confdev/confluence-rest-api/advanced-searching-using-cql). For example:\n\nExample request URI(s):\n\n- `http://localhost:8080/confluence/rest/api/search?cql=creator=currentUser()&type%20in%20(space,page,user)&cqlcontext={\"spaceKey\":\"TST\", \"contentId\":\"55\"}`\n\n- `http://localhost:8080/confluence/rest/api/search?cql=siteSearch~'example'%20AND%20label=docs&expand=content.space,space.homepage&limit=10`")
    @Parameters(value={@Parameter(name="cql", description="the CQL query see <a href='https://developer.atlassian.com/confdev/confluence-rest-api/advanced-searching-using-cql'>advanced searching in confluence using CQL</a>", in=ParameterIn.QUERY), @Parameter(name="cqlcontext", description="the execution context for CQL functions, provides current space key and content id. If this is not provided some CQL functions will not be available.", in=ParameterIn.QUERY), @Parameter(name="excerpt", description="the excerpt strategy to apply to the result, one of : indexed, highlight, none. This defaults to highlight.", in=ParameterIn.QUERY), @Parameter(name="cqlcontext", description="the execution context for CQL functions, provides current space key and content id. If this is not provided some CQL functions will not be available.", in=ParameterIn.QUERY), @Parameter(name="expand", description="the properties to expand on the search result, this may cause database requests for some properties", in=ParameterIn.QUERY), @Parameter(name="start", description="he start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY), @Parameter(name="includeArchivedSpaces", description="whether to include content in archived spaces in the result, this defaults to false.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a full JSON representation of a list of search results.", responseCode=200, representation=SearchResult.class, paged=true), @ResponseDoc(documentation="returned if the query cannot be parsed", responseCode=400, restError=true)})
    @GET
    @GraphQLName(value="search")
    @ScopesAllowed(requiredScope={"READ"})
    public SearchPageResponse<SearchResult> search(@GraphQLName(value="cql") @GraphQLNonNull @QueryParam(value="cql") String cql, @GraphQLName(value="cqlcontext") @QueryParam(value="cqlcontext") String cqlcontext, @GraphQLName(value="excerpt") @QueryParam(value="excerpt") @DefaultValue(value="highlight") String excerpt, @GraphQLExpansionParam @QueryParam(value="expand") String expand, @GraphQLName(value="offset") @QueryParam(value="start") @DefaultValue(value="0") int offset, @GraphQLName(value="after") String afterOffset, @GraphQLName(value="first") @QueryParam(value="limit") @DefaultValue(value="25") int limit, @GraphQLName(value="includeArchivedSpaces") @QueryParam(value="includeArchivedSpaces") @DefaultValue(value="false") boolean includeArchivedSpaces, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)cql)) {
            throw new BadRequestException("cql query parameter is required");
        }
        SearchContext searchContext = !Strings.isNullOrEmpty((String)cqlcontext) ? SearchContextSerialization.deserializeSearchContext((String)cqlcontext, (ObjectMapper)this.mapper) : SearchContext.builder().build();
        SearchOptions searchOptions = SearchOptions.builder().searchContext(searchContext).excerptStrategy(excerpt).includeArchivedSpaces(includeArchivedSpaces).fireSearchPerformed(true).build();
        return this.searchService.search(cql, searchOptions, (PageRequest)new RestPageRequest(uriInfo.getRequestUri(), GraphQLOffsetCursor.parseOffset(offset, afterOffset), limit), ExpansionsParser.parse((String)expand));
    }
}

