/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.ServerInformation;
import com.atlassian.confluence.api.service.server.ServerInformationService;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/server-information")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@SendsAnalytics
@Tag(name="Server Information")
public final class ServerInformationResource {
    private final ServerInformationService serverInformationService;

    @Inject
    public ServerInformationResource(@ComponentImport ServerInformationService serverInformationService) {
        this.serverInformationService = serverInformationService;
    }

    @Operation(summary="Get server information", description="Returns information about the current application build running on this instance.")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The server build information.", representation=ServerInformation.class), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response index() {
        ServerInformation serverInformation = this.serverInformationService.getServerInformation();
        return Response.ok((Object)serverInformation).build();
    }
}

