/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.colorscheme.ColorSchemeThemeBasedModel;
import com.atlassian.confluence.api.colorscheme.SpaceColorSchemeTypeModel;
import com.atlassian.confluence.api.service.colorscheme.SpaceColorSchemeService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/space/{spaceKey}/color-scheme")
@Tag(name="SpaceColorScheme")
public class SpaceColorSchemeResource {
    private final SpaceColorSchemeService spaceColorSchemeService;

    @Inject
    SpaceColorSchemeResource(@ComponentImport SpaceColorSchemeService spaceColorSchemeService) {
        this.spaceColorSchemeService = spaceColorSchemeService;
    }

    @Operation(summary="Get Space color scheme", description="Get information about the current color scheme for a space\n\n")
    @Parameter(name="spaceKey", description="space key of the space to request color scheme for.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of color scheme", responseCode=200, representation=ColorSchemeThemeBasedModel.class), @ResponseDoc(documentation="Returned if a space with the given space key does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if a space with the user is not space admin for the given space.", responseCode=403, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public ColorSchemeThemeBasedModel getSpaceColorScheme(@PathParam(value="spaceKey") String spaceKey) {
        return this.spaceColorSchemeService.getSpaceColorScheme(spaceKey);
    }

    @Operation(summary="Update Space color scheme", description="Update the color scheme for a space\n\n")
    @Parameter(name="spaceKey", description="space key of the space to set color scheme for.", in=ParameterIn.PATH)
    @RequestBody(description="New color scheme", content={@Content(schema=@Schema(implementation=ColorSchemeThemeBasedModel.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of color scheme", responseCode=200, representation=ColorSchemeThemeBasedModel.class), @ResponseDoc(documentation="Returned if a space with the given space key does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if there are invalid colors in the request", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if a space with the user is not space admin for the given space.", responseCode=403, restError=true)})
    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    public ColorSchemeThemeBasedModel updateSpaceColorScheme(@PathParam(value="spaceKey") String spaceKey, ColorSchemeThemeBasedModel colorScheme) {
        this.spaceColorSchemeService.setSpaceColorScheme(spaceKey, colorScheme);
        return this.spaceColorSchemeService.getSpaceColorScheme(spaceKey);
    }

    @Operation(summary="Get Space color scheme type", description="Get the current color scheme type used for a space, it can be global or custom\n\n")
    @Parameter(name="spaceKey", description="Space key of the space to request color scheme type for.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a color scheme type", responseCode=200, representation=SpaceColorSchemeTypeModel.class), @ResponseDoc(documentation="Returned if a space with the given space key does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if a space with the user for given space key is not space admin.", responseCode=403, restError=true)})
    @GET
    @Path(value="/type")
    @ScopesAllowed(requiredScope={"READ"})
    public SpaceColorSchemeTypeModel getColorSchemeType(@PathParam(value="spaceKey") String spaceKey) {
        return this.spaceColorSchemeService.getColorSchemeTypeForSpace(spaceKey);
    }

    @Operation(summary="Update Space color scheme type", description="Update the color scheme type used for a space, currently it can be global or custom\n\n")
    @Parameter(name="spaceKey", description="space key of the space to update color scheme type for.", in=ParameterIn.PATH)
    @RequestBody(description="New color scheme type", content={@Content(schema=@Schema(implementation=SpaceColorSchemeTypeModel.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns the updated color scheme type", responseCode=200, representation=SpaceColorSchemeTypeModel.class), @ResponseDoc(documentation="Returned if a space with the given space key does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if space type is invalid in the request", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if a space with the user is not space admin for the given space.", responseCode=403, restError=true)})
    @PUT
    @Path(value="/type")
    @ScopesAllowed(requiredScope={"WRITE"})
    public SpaceColorSchemeTypeModel updateColorSchemeType(@PathParam(value="spaceKey") String spaceKey, SpaceColorSchemeTypeModel colorSchemeType) {
        this.spaceColorSchemeService.setColorSchemeTypeForSpace(spaceKey, colorSchemeType);
        return this.spaceColorSchemeService.getColorSchemeTypeForSpace(spaceKey);
    }

    @Operation(summary="Reset Space color scheme", description="Reset the space color scheme to use global color scheme\n\n")
    @Parameter(name="spaceKey", description="Space key of the space to reset color scheme for.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a JSON representation of color scheme", responseCode=200, representation=ColorSchemeThemeBasedModel.class), @ResponseDoc(documentation="Returned if a space with the given space key does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if a space with the user is not space admin for the given space.", responseCode=403, restError=true)})
    @PUT
    @Path(value="/reset")
    @ScopesAllowed(requiredScope={"WRITE"})
    public ColorSchemeThemeBasedModel resetSpaceColorScheme(@PathParam(value="spaceKey") String spaceKey) {
        this.spaceColorSchemeService.resetSpaceColorScheme(spaceKey);
        return this.spaceColorSchemeService.getSpaceColorScheme(spaceKey);
    }
}

