/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.SpaceLabelService;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@Path(value="/space/{spaceKey}/labels")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@SendsAnalytics
@Tag(name="Space Label")
public final class SpaceLabelResource {
    private final SpaceLabelService spaceLabelService;

    @Inject
    public SpaceLabelResource(@ComponentImport SpaceLabelService spaceLabelService) {
        this.spaceLabelService = spaceLabelService;
    }

    @Operation(summary="Fetch all labels", description="Returns a paginated list of all Labels used by Content within the given Space.\nThis includes Labels used by Pages, Blog Posts, and other Content types.\n\nExample request URI:\n`https://example.com/confluence/rest/api/space/TEST/labels`")
    @Parameters(value={@Parameter(name="spaceKey", description="a string containing the key of the space", in=ParameterIn.PATH), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="a JSON representation of the lists label, or an empty list if no labels are found.", responseCode=200, representation=Label.class, paged=true), @ResponseDoc(documentation="If the calling user does not have permission to view the given space.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is no space with the given spaceKey.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Label> index(@Context UriInfo uriInfo, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.spaceLabelService.findAllContentLabelsPaginated(spaceKey, (PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)labels).pageRequest((PageRequest)pageRequest.copyWithLimits(labels)).build();
    }

    @Operation(summary="Get popular labels", description="Returns a paginated list of all Labels used by Content within the given Space.This includes Labels used by Pages, Blog Posts, and other Content types.\n\nExample request URI(s):\n`https://example.com/confluence/rest/api/space/TEST/labels/popular`")
    @Parameters(value={@Parameter(name="spaceKey", description="a string containing the key of the space", in=ParameterIn.PATH), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the lists label, or an empty list if no labels are found.", responseCode=200, representation=Label.class, paged=true), @ResponseDoc(documentation="returned if the calling user does not have permission to view the given space.", responseCode=403, restError=true), @ResponseDoc(documentation="returned if there is no space with the given spaceKey.", responseCode=404, restError=true)})
    @GET
    @Path(value="/popular")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Label> popular(@Context UriInfo uriInfo, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.spaceLabelService.findPopularContentLabelsPaginated(spaceKey, (PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)labels).pageRequest((PageRequest)pageRequest.copyWithLimits(labels)).build();
    }

    @Operation(summary="Get recent labels", description="Returns a paginated list of the most recent Labels used by Content within the given Space.This includes Labels used by Pages, Blog Posts, and other Content types.\n\nExample request URI:\n`https://example.com/confluence/rest/api/space/TEST/labels/recent`")
    @Parameters(value={@Parameter(name="spaceKey", description="a string containing the key of the space", in=ParameterIn.PATH), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a full JSON representation of a piece of content.", responseCode=200, representation=Label.class, paged=true), @ResponseDoc(documentation="If the calling user does not have permission to view the given space.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is no space with the given spaceKey.", responseCode=404, restError=true)})
    @GET
    @Path(value="/recent")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Label> recent(@Context UriInfo uriInfo, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.spaceLabelService.findRecentContentLabelsPaginated(spaceKey, (PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)labels).pageRequest((PageRequest)pageRequest.copyWithLimits(labels)).build();
    }

    @Operation(summary="Get related labels", description="Returns a paginated list of related Labels used by Content within the given Space.A Label is defined as being related to another when it is found attached to the same Content as the Label specified in the request.\n\nExample request URI:\n`https://example.com/confluence/rest/api/space/TEST/labels/example-label/related`")
    @Parameters(value={@Parameter(name="spaceKey", description="a string containing the key of the space", in=ParameterIn.PATH), @Parameter(name="labelName", description="a string containing the name of the label", in=ParameterIn.PATH), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="a JSON representation of the lists label, or an empty list if no labels are found.", responseCode=200, representation=Label.class, paged=true), @ResponseDoc(documentation="If the calling user does not have permission to view the given space.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is no space with the given spaceKey.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{labelName}/related")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Label> related(@Context UriInfo uriInfo, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="labelName") String labelName, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse labels = this.spaceLabelService.findRelatedContentLabelsPaginated(spaceKey, labelName, (PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)labels).pageRequest((PageRequest)pageRequest.copyWithLimits(labels)).build();
    }
}

