/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.model.permissions.SpacePermission;
import com.atlassian.confluence.api.model.permissions.SpacePermissionsForSubject;
import com.atlassian.confluence.api.service.permissions.SpacePermissionService;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
@SendsAnalytics
@Tag(name="Space Permissions")
@Path(value="/space/{spaceKey}/permissions")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"})
public class SpacePermissionResource {
    private final SpacePermissionService spacePermissionService;

    @Inject
    public SpacePermissionResource(@ComponentImport SpacePermissionService spacePermissionService) {
        this.spacePermissionService = spacePermissionService;
    }

    @Operation(summary="Get all space permissions", description="Returns list of permissions granted to users and groups in the particular space.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions`")
    @ApiResponse(responseCode="200", description="Returns a JSON representation of all permissions granted to users/groups/anonymous user in specified space.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SpacePermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ", "READ_ALL"})
    public Response getAllSpacePermissions(@PathParam(value="spaceKey") String spaceKey) {
        List spacePermissions = this.spacePermissionService.getAllPermissions(spaceKey);
        return Response.ok((Object)spacePermissions).build();
    }

    @Operation(summary="Gets the permissions granted to a user in a space", description="Returns list of permissions granted to user in the particular space.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/user/4028ae289154667d0191546bd5840000`")
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the space permissions granted to the user.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SpacePermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if the user with specified key not found.", restError=true)})
    @GET
    @Path(value="/user/{userKey}")
    @ScopesAllowed(requiredScope={"READ", "READ_ALL"})
    public Response getPermissionsGrantedToUser(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="userKey") String userKey) {
        List spacePermissions = this.spacePermissionService.getPermissionsGrantedToUser(spaceKey, userKey);
        return Response.ok((Object)spacePermissions).build();
    }

    @Operation(summary="Gets the permissions granted to an anonymous user in a space", description="Returns list of permissions granted to anonymous user in the particular space.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/anonymous`")
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the space permissions granted to the anonymous user.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SpacePermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true)})
    @GET
    @Path(value="/anonymous")
    @ScopesAllowed(requiredScope={"READ", "READ_ALL"})
    public Response getPermissionsGrantedToAnonymousUsers(@PathParam(value="spaceKey") String spaceKey) {
        List spacePermissions = this.spacePermissionService.getPermissionsGrantedToAnonymousUsers(spaceKey);
        return Response.ok((Object)spacePermissions).build();
    }

    @Operation(summary="Gets the permissions granted to a group in a space", description="Returns list of permissions granted to a group in the particular space.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/group/test-group-name`")
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the space permissions granted to the group.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SpacePermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if group with specified name not found.", restError=true)})
    @GET
    @Path(value="/group/{groupName}")
    @ScopesAllowed(requiredScope={"READ", "READ_ALL"})
    public Response getPermissionsGrantedToGroup(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="groupName") String groupName) {
        List spacePermissions = this.spacePermissionService.getPermissionsGrantedToGroup(spaceKey, groupName);
        return Response.ok((Object)spacePermissions).build();
    }

    @Operation(summary="Grants space permissions to a user", description="Grant permissions to a user in the given space.\nOperation doesn't override existing permissions, will only add those one that weren't granted before.\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n* space read\n* space administer\n* space export\n* space restrict\n* space delete_own\n* space delete_mail\n* page create\n* page delete\n* blogpost create\n* blogpost delete\n* comment create\n* comment delete\n* attachment create\n* attachment delete\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Space+Permissions+Overview\">Space Permissions documentation</a> for additional information about supported permissions.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/user/4028ae289154667d0191546bd5840000/grant`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)), examples={@ExampleObject(value="[\n    {\n        \"targetType\": \"space\",\n        \"operationKey\": \"read\"\n    },\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"create\"\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Space permissions successfully granted to a user."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if user with specified key not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="user/{userKey}/grant")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response grantPermissionsToUser(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="userKey") String userKey, Set<OperationDescription> permissions) {
        this.spacePermissionService.grantPermissionsToUser(spaceKey, userKey, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Grants space permissions to anonymous user", description="Grant permissions to anonymous user in the given space.\nOperation doesn't override existing permissions, will only add those one that weren't granted before.\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n* space read\n* space administer\n* space export\n* space restrict\n* space delete_own\n* space delete_mail\n* page create\n* page delete\n* blogpost create\n* blogpost delete\n* comment create\n* comment delete\n* attachment create\n* attachment delete\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Space+Permissions+Overview\">Space Permissions documentation</a> for additional information about supported permissions.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/anonymous/grant`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)), examples={@ExampleObject(value="[\n    {\n        \"targetType\": \"space\",\n        \"operationKey\": \"read\"\n    },\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"create\"\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Space permissions successfully granted to anonymous user."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="anonymous/grant")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response grantPermissionsToAnonymousUsers(@PathParam(value="spaceKey") String spaceKey, Set<OperationDescription> permissions) {
        this.spacePermissionService.grantPermissionsToAnonymousUser(spaceKey, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Grants space permissions to a group", description="Grant permissions to a group in the given space.\nOperation doesn't override existing permissions, will only add those one that weren't granted before.\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n* space read\n* space administer\n* space export\n* space restrict\n* space delete_own\n* space delete_mail\n* page create\n* page delete\n* blogpost create\n* blogpost delete\n* comment create\n* comment delete\n* attachment create\n* attachment delete\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Space+Permissions+Overview\">Space Permissions documentation</a> for additional information about supported permissions.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/group/test-group-name/grant`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)), examples={@ExampleObject(value="[\n    {\n        \"targetType\": \"space\",\n        \"operationKey\": \"read\"\n    },\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"create\"\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Space permissions successfully granted to a group."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if group with specified name not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="group/{groupName}/grant")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response grantPermissionsToGroup(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="groupName") String groupName, Set<OperationDescription> permissions) {
        this.spacePermissionService.grantPermissionsToGroup(spaceKey, groupName, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Revoke space permissions from a user", description="Revoke permissions from a user in the given space.\nIf user doesn't have permissions that we are trying to revoke, those permissions will be silently skipped.\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n* space read\n* space administer\n* space export\n* space restrict\n* space delete_own\n* space delete_mail\n* page create\n* page delete\n* blogpost create\n* blogpost delete\n* comment create\n* comment delete\n* attachment create\n* attachment delete\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Space+Permissions+Overview\">Space Permissions documentation</a> for additional information about supported permissions.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/user/4028ae289154667d0191546bd5840000/revoke`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)), examples={@ExampleObject(value="[\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"delete\"\n    },\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"create\"\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Space permissions successfully removed for a user."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if user with specified key not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="user/{userKey}/revoke")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response revokePermissionsFromUser(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="userKey") String userKey, Set<OperationDescription> permissions) {
        this.spacePermissionService.removePermissionsFromUser(spaceKey, userKey, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Revoke space permissions from anonymous user", description="Revoke permissions from anonymous user in the given space.\nIf anonymous user doesn't have permissions that we are trying to revoke, those permissions will be silently skipped.\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n* space read\n* space administer\n* space export\n* space restrict\n* space delete_own\n* space delete_mail\n* page create\n* page delete\n* blogpost create\n* blogpost delete\n* comment create\n* comment delete\n* attachment create\n* attachment delete\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Space+Permissions+Overview\">Space Permissions documentation</a> for additional information about supported permissions.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/anonymous/revoke`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)), examples={@ExampleObject(value="[\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"delete\"\n    },\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"create\"\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Space permissions successfully removed for anonymous user."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="anonymous/revoke")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response revokePermissionsFromAnonymousUser(@PathParam(value="spaceKey") String spaceKey, Set<OperationDescription> permissions) {
        this.spacePermissionService.removePermissionsFromAnonymousUser(spaceKey, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Revoke space permissions from a group", description="Revoke permissions from a group in the given space.\nIf group doesn't have permissions that we are trying to revoke, those permissions will be silently skipped.\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n* space read\n* space administer\n* space export\n* space restrict\n* space delete_own\n* space delete_mail\n* page create\n* page delete\n* blogpost create\n* blogpost delete\n* comment create\n* comment delete\n* attachment create\n* attachment delete\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Space+Permissions+Overview\">Space Permissions documentation</a> for additional information about supported permissions.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions/group/test-group-name/revoke`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)), examples={@ExampleObject(value="[\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"delete\"\n    },\n    {\n        \"targetType\": \"page\",\n        \"operationKey\": \"create\"\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Space permissions successfully removed for a group."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if group with specified key not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="group/{groupName}/revoke")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response revokePermissionsFromGroup(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="groupName") String groupName, Set<OperationDescription> permissions) {
        this.spacePermissionService.removePermissionsFromGroup(spaceKey, groupName, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Set permissions to multiple users/groups/anonymous user in the given space", description="Sets permissions to multiple users/groups in the given space.\nRequest should contain all permissions that user/group/anonymous user will have in a given space.\nIf permission is absent in the request, but was granted before, it will be revoked.\nIf empty list of permissions passed to user/group/anonymous user, then all their existing permissions will be revoked.\nIf user/group/anonymous user not mentioned in the request, their permissions will not be revoked.\n\nMaximum 40 different users/groups/anonymous user could be passed in the request.\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Space+Permissions+Overview\">Space Permissions documentation</a> for additional information about supported permissions.\n\nExample request URI's:\n`https://example.com/confluence/rest/api/space/TESTSPACE/permissions`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=SpacePermissionsForSubject.class)), examples={@ExampleObject(value="[\n    {\n        \"userKey\": \"4028ae289154667d0191546e11a10001\",\n        \"operations\": [\n            {\n                \"operationKey\": \"read\",\n                \"targetType\": \"space\"\n            },\n            {\n                \"operationKey\": \"administer\",\n                \"targetType\": \"space\"\n            }\n        ]\n    },\n    {\n        \"groupName\": \"group1\",\n        \"operations\": [\n            {\n                \"operationKey\": \"read\",\n                \"targetType\": \"space\"\n            },\n            {\n                \"operationKey\": \"create\",\n                \"targetType\": \"comment\"\n            }\n        ]\n    },\n    {\n        \"operations\": [\n            {\n                \"operationKey\": \"read\",\n                \"targetType\": \"space\"\n            }\n        ]\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Space permissions successfully set."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if user or group with specified key not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setPermissions(@PathParam(value="spaceKey") String spaceKey, Set<SpacePermissionsForSubject> spacePermissionsForSubjects) {
        this.spacePermissionService.setPermissions(spaceKey, spacePermissionsForSubjects);
        return Response.ok().build();
    }
}

