/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@AnonymousSiteAccess
@LimitRequestSize
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/space/{spaceKey}/property")
@Tag(name="Space Property")
@PathParamDoc(name="spaceKey", documentation="The key of the space")
@PublicApi
public class SpacePropertyResource {
    private static final String DEFAULT_LIMIT = "10";
    private final SpacePropertyService service;

    @Inject
    public SpacePropertyResource(@ComponentImport SpacePropertyService service) {
        this.service = service;
    }

    @Operation(summary="Create a space property", description="Creates a new space property.")
    @RequestBody(description="space property to be created", content={@Content(schema=@Schema(implementation=JsonSpaceProperty.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the space property.", responseCode=200, representation=JsonSpaceProperty.class), @ResponseDoc(documentation="Returned if the space already has a value with the given key, or no property value was provided, or the value is too long.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the user does not have permission to edit the space with the given key.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if the value is too long.", responseCode=413, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public JsonSpaceProperty create(@PathParam(value="spaceKey") String spaceKey, JsonSpaceProperty newProperty) throws ServiceException {
        JsonSpaceProperty propertyWithSpace = this.verifyAndUpdateWithSpace(spaceKey, newProperty);
        return this.service.create(propertyWithSpace);
    }

    @Operation(summary="Create a space property with a specific key", description="Create a space property with a specific key.")
    @RequestBody(description="space property to be created", content={@Content(schema=@Schema(implementation=JsonSpaceProperty.class))})
    @Parameter(name="key", description="property key of the property to be created", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the space property.", responseCode=200, representation=JsonSpaceProperty.class), @ResponseDoc(documentation="Returned if the space already has a value with the given key, or no property value was provided, or the value is too long.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the user does not have permission to edit the space with the given key.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if the value is too long.", responseCode=413, restError=true)})
    @POST
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public JsonSpaceProperty create(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="key") String propertyKey, JsonSpaceProperty newProperty) throws ServiceException {
        JsonSpaceProperty propertyWithSpace = this.verifyAndUpdateWithSpace(spaceKey, newProperty);
        JsonSpaceProperty propertyWithKey = this.verifyAndUpdateWithKey(propertyKey, propertyWithSpace);
        return this.service.create(propertyWithKey);
    }

    @Operation(summary="Get space properties", description="Returns a paginated list of space properties. \n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/TST/property?expand=space,version`")
    @Parameters(value={@Parameter(name="spaceKey", description="the space to find properties under. Required.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the space properties. Default value: <code>version</code>.", in=ParameterIn.QUERY), @Parameter(name="start", description="he start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="a JSON representation of the space properties.", responseCode=200, representation=JsonSpaceProperty.class, paged=true), @ResponseDoc(documentation="Returned if there is no space with the given key, or if the calling user does not have permission to view the space.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<JsonSpaceProperty> get(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="expand") @DefaultValue(value="version") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @Context UriInfo uriInfo) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse response = this.service.find(expansions).withSpaceKey(spaceKey).fetchMany((PageRequest)pageRequest);
        return RestList.newRestList().pageRequest((PageRequest)pageRequest).results(response).build();
    }

    @Operation(summary="Get space property by key", description="Returns a space property. \n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/TST/property/example-property-key?expand=space,version`")
    @Parameters(value={@Parameter(name="spaceKey", description="the space to find properties under. Required.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the space properties. Default value: <code>version</code>.", in=ParameterIn.QUERY), @Parameter(name="start", description="he start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the space property.", responseCode=200, representation=JsonSpaceProperty.class), @ResponseDoc(documentation="Returned if there is no space with the given key, or no property with the given key, or if the calling user does not have permission to view the space.", responseCode=404, restError=true)})
    @GET
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"READ"})
    public JsonSpaceProperty get(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="key") String propertyKey, @QueryParam(value="expand") @DefaultValue(value="version") String expand) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return (JsonSpaceProperty)this.service.find(expansions).withSpaceKey(spaceKey).withPropertyKey(propertyKey).fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No space property found with key: " + propertyKey)));
    }

    @Operation(summary="Update space property", description="Updates a space property.The body contains the representation of the space property. Must include new version number.If the given version number is 1, attempts to create a new space property.")
    @Parameters(value={@Parameter(name="spaceKey", description="the space to find properties under. Required.", in=ParameterIn.PATH), @Parameter(name="key", description="the key of the property", in=ParameterIn.PATH)})
    @RequestBody(description="space property to be updated", content={@Content(schema=@Schema(implementation=JsonSpaceProperty.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the property.", responseCode=200, representation=JsonSpaceProperty.class), @ResponseDoc(documentation="Returned if the given property has a different spaceKey to the one in the path, or if the property has a different key to the one in the path, or no property value was provided, or the value is too long.", responseCode=400, restError=true), @ResponseDoc(documentation="returned if the user does not have permission to edit the space with the given spaceKey.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is no space with the given key, or no property with the given key, or if the calling user does not have permission to view the space.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if the given version is does not match the expected target version of the updated property.", responseCode=409, restError=true), @ResponseDoc(documentation="Returned if the value is too long.", responseCode=413, restError=true)})
    @PUT
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public JsonSpaceProperty update(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="key") String propertyKey, JsonSpaceProperty property) throws ServiceException {
        JsonSpaceProperty propertyWithSpace = this.verifyAndUpdateWithSpace(spaceKey, property);
        JsonSpaceProperty propertyWithKey = this.verifyAndUpdateWithKey(propertyKey, propertyWithSpace);
        return this.service.update(propertyWithKey);
    }

    @Operation(summary="Delete space property", description="Deletes a space property. \n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/TST/property/example-property-key?expand=space,version`")
    @Parameters(value={@Parameter(name="spaceKey", description="the key of the space.", in=ParameterIn.PATH), @Parameter(name="key", description="the key of the property.", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if successfully deleted.", responseCode=204), @ResponseDoc(documentation="Returned if there is no space with the give key, property with the given property key, or if the calling user does not have permission to view the space.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response delete(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="key") String propertyKey) throws ServiceException {
        JsonSpaceProperty property = ((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space(Space.builder().key(spaceKey).build()).key(propertyKey)).build();
        this.service.delete(property);
        return Response.noContent().build();
    }

    private JsonSpaceProperty verifyAndUpdateWithKey(String pathKey, JsonSpaceProperty newProperty) {
        JsonSpaceProperty propertyWithKey = newProperty.getKey() != null ? newProperty : ((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder((JsonSpaceProperty)newProperty).key(pathKey)).build();
        if (!propertyWithKey.getKey().equals(pathKey)) {
            throw new BadRequestException("Path/value mismatch on key: " + pathKey + " vs. " + propertyWithKey.getKey());
        }
        return propertyWithKey;
    }

    private JsonSpaceProperty verifyAndUpdateWithSpace(String pathSpaceKey, JsonSpaceProperty newProperty) {
        JsonSpaceProperty propertyWithSpace = newProperty.getSpaceRef().existsAndExpanded() ? newProperty : JsonSpaceProperty.builder((JsonSpaceProperty)newProperty).space(Reference.to((Object)Space.builder().key(pathSpaceKey).build())).build();
        if (!propertyWithSpace.getSpace().getKey().equals(pathSpaceKey)) {
            throw new BadRequestException("Path/value mismatch on spaceKey: " + pathSpaceKey + " vs. " + propertyWithSpace.getSpace().getKey());
        }
        return propertyWithSpace;
    }
}

