/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.BlockedSpace;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.PersonalSpaceDetailsForCreation;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.pagination.SpaceFilterAwarePageResponse;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.service.content.ContentTrashService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.plugins.restapi.graphql.GraphQLOffsetCursor;
import com.atlassian.confluence.plugins.restapi.resources.LongTaskResource;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.confluence.rest.v2.api.services.RestNavigationService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.graphql.annotations.GraphQLName;
import com.atlassian.graphql.annotations.GraphQLProvider;
import com.atlassian.graphql.annotations.expansions.GraphQLExpansionParam;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/space")
@GraphQLProvider
@SendsAnalytics
@Tag(name="Space")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class SpaceResource {
    private final SpaceService spaceService;
    private final RestNavigationService navigationService;
    private final ContentTrashService contentTrashService;
    private ConfluenceScopesRequestCache scopesRequestCacheDelegate;
    private final PersonService personService;
    private static final String DEPTH_ALL = "all";

    @Inject
    public SpaceResource(@ComponentImport SpaceService spaceService, @ComponentImport RestNavigationService navigationService, @ComponentImport ContentTrashService contentTrashService, ConfluenceScopesRequestCache scopesRequestCacheDelegate, @ComponentImport PersonService personService) {
        this.spaceService = spaceService;
        this.navigationService = navigationService;
        this.contentTrashService = contentTrashService;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.personService = personService;
    }

    @Operation(summary="Creates a new Space.", description="Creates a new Space. The incoming Space does not include an id, but must include a Key and Name, and should include a Description.")
    @RequestBody(description="The space to be created", required=true, content={@Content(schema=@Schema(implementation=Space.class))})
    @ResponseDoc(documentation="Returns a full JSON representation of a space.", responseCode=200, representation=Space.class)
    @POST
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Space createSpace(Space newSpace) throws ServiceException {
        return this.spaceService.create(newSpace, false);
    }

    @Operation(summary="Create private space", description="Creates a new private Space, viewable only by its creator. The incoming Space does not include an id, but must include a Key and Name, and should include a Description.")
    @RequestBody(description="The space to be created", required=true, content={@Content(schema=@Schema(implementation=Space.class))})
    @ResponseDoc(documentation="Returns a full JSON representation of a space.", responseCode=200, representation=Space.class)
    @POST
    @Path(value="_private")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Space createPrivateSpace(Space newSpace) throws ServiceException {
        return this.spaceService.create(newSpace, true);
    }

    @Operation(summary="Creates the personal Space for self.", description="Creates a personal space for self.\n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/personal`")
    @RequestBody(description="The personal space to be created", required=true, content={@Content(schema=@Schema(implementation=PersonalSpaceDetailsForCreation.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a space.", responseCode=200, representation=Space.class), @ResponseDoc(documentation="Returned if current user does not have correct permission.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is invalid space description.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if personal space already exists for user.", responseCode=409, restError=true)})
    @POST
    @Path(value="personal")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Space createPersonalSpace(PersonalSpaceDetailsForCreation newSpaceDetail) throws ServiceException {
        return this.spaceService.createPersonalSpaceForSelf(newSpaceDetail);
    }

    @Operation(summary="Update Space", description="Updates a Space. The incoming Space must include a Key and Name, and should include a Description")
    @RequestBody(description="the space being updated", required=true, content={@Content(schema=@Schema(implementation=Space.class))})
    @Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a space.", responseCode=200, representation=Space.class), @ResponseDoc(documentation="Returned if there is no space with the given key, or if the calling userdoes not have permission to update it.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{spaceKey}")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Space update(@PathParam(value="spaceKey") String spaceKey, Space space) throws ServiceException {
        String keyInObject = space.getKey();
        if (Strings.isNullOrEmpty((String)keyInObject)) {
            space = Space.builder((Space)space).key(spaceKey).build();
        } else if (!spaceKey.equals(keyInObject)) {
            throw new BadRequestException("Updated Space has incorrect key: " + keyInObject);
        }
        return this.spaceService.update(space);
    }

    @Operation(summary="Delete Space", description="Deletes a Space. The space is deleted in a long running task, so the space cannot be considered deleted when this resource returns. Clients can follow the status link in the response and poll it until the task completes.")
    @Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a pointer to the status of the space-deletion task.", responseCode=202, representation=LongTaskSubmission.class), @ResponseDoc(documentation="Returned if there is no space with the given key, or if the calling user does not have permission to delete it.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{spaceKey}")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response delete(@PathParam(value="spaceKey") String spaceKey) throws ServiceException, URISyntaxException {
        Space space = Space.builder().key(spaceKey).build();
        LongTaskSubmission submissionResult = this.spaceService.delete(space);
        return LongTaskResource.submissionResponse(submissionResult);
    }

    @Operation(summary="Get space", description="Returns information about a space. \n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/TST?expand=description`")
    @Parameters(value={@Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the space.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a space.", responseCode=200, representation=Space.class), @ResponseDoc(documentation="Returned if there is no space with the given key, or if the calling user does not have permission to view the space.", responseCode=404, restError=true)})
    @GET
    @Path(value="{spaceKey}")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL", "READ", "JSM_KB"})
    @PublicApi
    public Space space(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="xoauth_requestor_id") String username) {
        if (this.scopesRequestCacheDelegate != null && this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB") && username != null) {
            this.personService.setCurrentUser(username);
        }
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        Optional space = this.spaceService.find(expansions).withKeys(new String[]{spaceKey}).fetch();
        return (Space)space.orElseThrow(ServiceExceptionSupplier.notFound((String)("No space found with key : " + spaceKey)));
    }

    @Operation(summary="Get spaces by key", description="Returns information about a number of spaces. \n\nExample request URI(s): \n\n`http://example.com/confluence/rest/api/space?spaceKey=TST&spaceKey=ds`")
    @Parameters(value={@Parameter(name="spaceKey", description="the key of the space to fetch information from.", in=ParameterIn.QUERY), @Parameter(name="spaceKeys", description="the keys of the spaces to fetch information from.", in=ParameterIn.QUERY), @Parameter(name="spaceIds", description="the ids of the spaces to fetch information from. Cannot be used in conjunction with spaceKey(s)", in=ParameterIn.QUERY), @Parameter(name="type", description="filter the list of spaces returned by type (global, personal).", in=ParameterIn.QUERY), @Parameter(name="status", description="filter the list of spaces returned by status (current, archived).", in=ParameterIn.QUERY), @Parameter(name="label", description="filter the list of spaces returned by label.", in=ParameterIn.QUERY), @Parameter(name="contentLabel", description="filter the list of spaces returned by content containing provided label.", in=ParameterIn.QUERY), @Parameter(name="favourite", description="filter the list of spaces returned by favourites.", in=ParameterIn.QUERY), @Parameter(name="hasRetentionPolicy", description="filter the list of spaces returned by retention policy.", in=ParameterIn.QUERY), @Parameter(name="expand", description="a comma separated list of properties to expand on the spaces.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of spaces to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDoc(documentation="Returns an array of full JSON representations of found space.", responseCode=200, representation=Space.class, paged=true)
    @GET
    @GraphQLName(value="spaces")
    @RateLimited(propertyName="confluence.full.sync.rl.spaces.rps", permitsPerSecond=15.0, type=RateLimited.Type.TWO_LO)
    @ScopesAllowed(requiredScope={"READ_ALL", "READ", "JSM_KB"})
    @PublicApi
    public PageResponse<Space> spaces(@GraphQLName(value="spaceKey") @QueryParam(value="spaceKeySingle") String spaceKey, @GraphQLName(value="spaceKeys") @QueryParam(value="spaceKey") List<String> spaceKeys, @GraphQLName(value="spaceIds") @QueryParam(value="spaceId") List<String> spaceIds, @GraphQLName(value="type") @QueryParam(value="type") String type, @GraphQLName(value="status") @QueryParam(value="status") String status, @GraphQLName(value="label") @QueryParam(value="label") List<String> labelNames, @GraphQLName(value="contentLabel") @QueryParam(value="contentLabel") List<String> contentLabelNames, @GraphQLName(value="favourite") @QueryParam(value="favourite") Boolean favourite, @GraphQLName(value="hasRetentionPolicy") @QueryParam(value="hasRetentionPolicy") Boolean hasRetentionPolicy, @GraphQLExpansionParam @QueryParam(value="expand") @DefaultValue(value="") String expand, @GraphQLName(value="offset") @QueryParam(value="start") int offset, @GraphQLName(value="after") String afterOffset, @GraphQLName(value="first") @QueryParam(value="limit") @DefaultValue(value="25") int limit, @GraphQLName(value="xoauth_requestor_id") @QueryParam(value="xoauth_requestor_id") String username, @Context UriInfo uriInfo) throws ServiceException {
        if (this.scopesRequestCacheDelegate != null && this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB") && username != null) {
            this.personService.setCurrentUser(username);
        }
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        SpaceService.SpaceFinder finder = this.spaceService.find(expansions);
        if (!(spaceKeys.isEmpty() && spaceKey == null || spaceIds.isEmpty())) {
            throw new BadRequestException("Space key(s) and space IDs cannot be provided at the same time, use only space key(s) or space IDs");
        }
        if (!spaceKeys.isEmpty()) {
            finder.withKeys(spaceKeys.toArray(new String[spaceKeys.size()]));
        }
        if (spaceKey != null) {
            finder.withKeys(new String[]{spaceKey});
        }
        if (!spaceIds.isEmpty()) {
            Set spaceIdSet = spaceIds.stream().map(Long::parseLong).collect(Collectors.toSet());
            finder.withIds(spaceIdSet);
        }
        if (!Strings.isNullOrEmpty((String)type)) {
            finder.withType(SpaceType.forName((String)type));
        }
        if (!Strings.isNullOrEmpty((String)status)) {
            finder.withStatus(SpaceStatus.valueOf((String)status));
        }
        if (!labelNames.isEmpty()) {
            List<Label> labels = labelNames.stream().map(name -> Label.builder((String)name).prefix(Label.Prefix.team).build()).toList();
            finder.withLabels(labels.toArray(new Label[labels.size()]));
        }
        if (!contentLabelNames.isEmpty()) {
            finder.withContentContainingLabels(contentLabelNames);
        }
        if (favourite != null) {
            finder.withIsFavourited(favourite.booleanValue());
        }
        if (hasRetentionPolicy != null) {
            finder.withHasRetentionPolicy(hasRetentionPolicy.booleanValue());
        }
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), GraphQLOffsetCursor.parseOffset(offset, afterOffset), limit);
        PageResponse results = finder.fetchMany((PageRequest)request);
        RestList restList = RestList.createRestList((PageRequest)request.copyWithLimits(results), (PageResponse)results);
        if (results instanceof SpaceFilterAwarePageResponse && ((SpaceFilterAwarePageResponse)results).getBlockedList().isPresent()) {
            Optional blockedList = ((SpaceFilterAwarePageResponse)results).getBlockedList();
            if (!spaceIds.isEmpty()) {
                restList.putProperty("ignoredBySpaceFilter", ((List)blockedList.get()).stream().map(BlockedSpace::getBlockedSpaceId).toList());
            } else if (!spaceKeys.isEmpty()) {
                restList.putProperty("ignoredBySpaceFilter", ((List)blockedList.get()).stream().map(BlockedSpace::getBlockedSpaceKey).toList());
            }
        }
        return restList;
    }

    @Operation(summary="Get contents in space", description="Returns the content in this given space. \n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/TEST/content?expand=history`")
    @Parameters(value={@Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH), @Parameter(name="depth", description="a string indicating if all content, or just the root content of the space is returned. Default value: <code>all</code>. Valid values: <code>all, root</code>.", in=ParameterIn.QUERY), @Parameter(name="expand", description="a comma separated list of properties to expand on the space.", in=ParameterIn.QUERY), @Parameter(name="start", description="he start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a piece of content.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class, paged=true), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="{spaceKey}/content")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public Map<ContentType, RestList<com.atlassian.confluence.api.model.content.Content>> contents(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="depth") @DefaultValue(value="all") String depth, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        SimplePageRequest pageRequest = new SimplePageRequest(start, limit);
        Space space = this.space(spaceKey, "", null);
        Depth spaceContentDepth = Depth.valueOf((String)depth.toUpperCase());
        Map content = this.spaceService.findContent(space, expansions).withDepth(spaceContentDepth).fetchMappedByType((PageRequest)pageRequest);
        Navigation.SpaceContentNav spaceContentNav = this.navigationService.createNavigation().space(space).content();
        return BuilderUtils.modelMap((Map)Maps.transformEntries((Map)content, (key, pageResponse) -> {
            Navigation.Builder spaceContentTypeUri = spaceContentNav.type(key);
            return RestList.createRestList((PageRequest)spaceContentTypeUri.createPageRequest(pageResponse.getPageRequest()), (PageResponse)pageResponse);
        }));
    }

    @Operation(summary="Get contents by type", description="Returns the content in this given space with the given type. \n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/TEST/content/page?expand=history`")
    @Parameters(value={@Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH), @Parameter(name="type", description="the type of content to return with the space. Valid values: <code>page, blogpost</code>.", in=ParameterIn.PATH), @Parameter(name="depth", description="a string indicating if all content, or just the root content of the space is returned. Default value: <code>all</code>. Valid values: <code>all, root</code>.", in=ParameterIn.QUERY), @Parameter(name="expand", description="a comma separated list of properties to expand on the space.", in=ParameterIn.QUERY), @Parameter(name="start", description="he start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a piece of content.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class, paged=true), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="{spaceKey}/content/{type}")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public RestList<com.atlassian.confluence.api.model.content.Content> contentsWithType(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="type") String type, @QueryParam(value="depth") @DefaultValue(value="all") String depth, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @Context UriInfo uriInfo) throws ServiceException {
        ContentType contentType = ContentType.valueOf((String)type);
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Space space = this.space(spaceKey, "", null);
        Depth spaceContentDepth = Depth.valueOf((String)depth.toUpperCase());
        PageResponse response = this.spaceService.findContent(space, expansions).withDepth(spaceContentDepth).fetchMany(contentType, (PageRequest)pageRequest);
        return RestList.createRestList((PageRequest)pageRequest.copyWithLimits(response), (PageResponse)response);
    }

    @Operation(summary="Archive space", description="Archive the given Space identified by spaceKey. This method is idempotent i.e., if the Space is already archived then no action will be taken.")
    @Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="No Content if the Space is archived successfully or already has status 'ARCHIVED'.", responseCode=204), @ResponseDoc(documentation="Returned if the calling user is not authenticated.", responseCode=401, restError=true), @ResponseDoc(documentation="Returned if the calling user does not have permission to edit the Space.", responseCode=403, restError=true), @ResponseDoc(documentation=" Returned if there is no space with the given key, or if the calling user does not have permission to view it.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{spaceKey}/archive")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response archive(@PathParam(value="spaceKey") String spaceKey) {
        this.spaceService.archive(spaceKey);
        return Response.noContent().build();
    }

    @Operation(summary="Restore space", description="Restore the given Space identified by spaceKey. This method is idempotent i.e., if the Space is already restored then no action will be taken.")
    @Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="No Content if the Space is restored successfully or already has status 'CURRENT'.", responseCode=204), @ResponseDoc(documentation="Returned if the calling user is not authenticated.", responseCode=401, restError=true), @ResponseDoc(documentation="Returned if the calling user does not have permission to edit the Space.", responseCode=403, restError=true), @ResponseDoc(documentation=" Returned if there is no space with the given key, or if the calling user does not have permission to view it.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{spaceKey}/restore")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response restore(@PathParam(value="spaceKey") String spaceKey) {
        this.spaceService.restore(spaceKey);
        return Response.noContent().build();
    }

    @Operation(summary="Remove all trash contents", description="Remove all content from the trash in the given space, deleting them permanently.Example request URI: \n\n`http://example.com/confluence/rest/api/space/TEST/trash`")
    @Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns no content if trash is emptied successfully", responseCode=204), @ResponseDoc(documentation="Returned if user does not have correct permission", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is no space with the given key", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{spaceKey}/trash")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response trash(@PathParam(value="spaceKey") String spaceKey) throws ServiceException {
        this.spaceService.emptyTrash(spaceKey);
        return Response.noContent().build();
    }

    @Operation(summary="Get trash contents of space", description="Returns the trash contents in this given space. \n\nExample request URI: \n\n`http://example.com/confluence/rest/api/space/TEST/trash?limit=100&cursor=content:false:612345`", extensions={@Extension(name="x-response-metadata", properties={@ExtensionProperty(name="cursorPaged", value="true")})})
    @Parameters(value={@Parameter(name="spaceKey", description="the key of the space to update.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the space.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY), @Parameter(name="cursor", description="the identifier which is used to skip results from a previous query when paginating. Cursor is empty in first request, to move forward or backward use cursor provided in response.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns an array of full JSON representations of trash contents.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class, paged=true), @ResponseDoc(documentation="Returned if the calling user does not have admin permission of the Space.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if space not found by space key.", responseCode=404, restError=true)})
    @GET
    @Path(value="{spaceKey}/trash")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public RestList<com.atlassian.confluence.api.model.content.Content> contentsWithType(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="expand") @DefaultValue(value="ancestors,container,space,metadata") String expand, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="cursor") String cursor, @Context UriInfo uriInfo) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        ContentCursor contentCursor = StringUtils.isEmpty((CharSequence)cursor) ? ContentCursor.EMPTY_CURSOR : ContentCursor.valueOf((String)cursor);
        LimitedRequest request = LimitedRequestImpl.create((Cursor)contentCursor, (int)limit, (int)Integer.parseInt("500"));
        PageResponse response = this.contentTrashService.getTrashContents(Space.builder().key(spaceKey).build(), request, expansions);
        return RestList.createRestList((PageRequest)new RestPageRequest(uriInfo.getRequestUri(), (Cursor)contentCursor, limit), (PageResponse)response);
    }
}

