/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.watch.WatchService;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@Path(value="/space/{spaceKey}/watchers")
@PathParamDoc(name="spaceKey", documentation="the key of the Space the User is attempting to view.")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@SendsAnalytics
@Tag(name="Space Watchers")
public final class SpaceWatcherResource {
    private final WatchService watchService;

    @Inject
    public SpaceWatcherResource(@ComponentImport WatchService watchService) {
        this.watchService = watchService;
    }

    @Operation(summary="Fetch users watching space", description="Returns a paginated list of users watching the given Space identified by spaceKey. Only a Confluence Administrator or Space Administrator can perform this action.")
    @Parameters(value={@Parameter(name="start", description="the start point of the collection to return"), @Parameter(name="limit", description="the limit of the number of Users to return, this may be restricted by fixed system limits")})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a paginated list of users watching the given Space identified by spaceKey", responseCode=200, representation=User.class, paged=true), @ResponseDoc(documentation="The user is not authenticated or does not have the <b>LICENSED</b> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The user is not a Confluence Administrator or Space Administrator.", responseCode=403, restError=true), @ResponseDoc(documentation="The Space does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<User> index(@Context UriInfo uriInfo, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse users = this.watchService.findUsersWatchingSpacePaginated(spaceKey, (PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)users).pageRequest((PageRequest)pageRequest.copyWithLimits(users)).build();
    }
}

