/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/user/{username}/group/{groupName}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@SystemAdminOnly
@SendsAnalytics
@Tag(name="User Group")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public final class UserGroupResource {
    private final PersonService personService;

    @Inject
    public UserGroupResource(@ComponentImport PersonService personService) {
        this.personService = personService;
    }

    @Operation(summary="Update user group", description="Add the given User identified by username to the given Group identified by groupName. \n\nThis method is idempotent i.e., if the membership already exists then no action will be taken.")
    @Parameters(value={@Parameter(name="username", description="The username identifying the given user.", in=ParameterIn.PATH), @Parameter(name="groupName", description="The group name identifying the given group.", in=ParameterIn.PATH)})
    @ResponseDoc(documentation="No Content if the user is successfully added to the group", responseCode=204)
    @PUT
    public Response update(@PathParam(value="username") String username, @PathParam(value="groupName") String groupName) {
        this.personService.addMembership(username, groupName);
        return Response.noContent().build();
    }

    @Operation(summary="Delete user group", description="Removes the given User identified by username from the given Group identified by groupName. \n\nThis method is idempotent i.e., if the membership already exists then no action will be taken.")
    @Parameters(value={@Parameter(name="username", description="The username identifying the given user.", in=ParameterIn.PATH), @Parameter(name="groupName", description="The group name identifying the given group.", in=ParameterIn.PATH)})
    @ResponseDoc(documentation="No Content if the user is successfully removed from the group", responseCode=204)
    @DELETE
    public Response delete(@PathParam(value="username") String username, @PathParam(value="groupName") String groupName) {
        this.personService.removeMembership(username, groupName);
        return Response.noContent().build();
    }
}

