/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.PasswordChangeDetails;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.people.UserDetailsForUpdate;
import com.atlassian.confluence.api.model.people.UserSettings;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.api.service.settings.UserSettingsService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.graphql.annotations.GraphQLName;
import com.atlassian.graphql.annotations.GraphQLProvider;
import com.atlassian.graphql.annotations.expansions.GraphQLExpansionParam;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Strings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/user")
@LimitRequestSize(value=0x500000L)
@GraphQLProvider
@SendsAnalytics
@Tag(name="User")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class UserResource {
    private final PersonService personService;
    private final GroupService groupService;
    private final UserSettingsService userSettingsService;

    @Inject
    public UserResource(@ComponentImport PersonService personService, @ComponentImport GroupService groupService, @ComponentImport UserSettingsService userSettingsService) {
        this.personService = personService;
        this.groupService = groupService;
        this.userSettingsService = userSettingsService;
    }

    @GraphQLName(value="user")
    public Person getUserGraph(@GraphQLName(value="current") @DefaultValue(value="false") boolean current, @GraphQLName(value="key") String key, @GraphQLName(value="username") String username, @GraphQLExpansionParam String expand) {
        if (current) {
            return this.getCurrent(expand);
        }
        return this.getUser(key, username, expand);
    }

    @Operation(summary="Get user", description="Get information about a user identified by either user key or username. Example request URI(s):\n\n`http://example.com/confluence/rest/api/user?username=jblogs`\n`http://example.com/confluence/rest/api/user?key=402880824ff933a4014ff9345d7c0002`")
    @Parameters(value={@Parameter(name="key", description="userkey of the user to request from this resource.", in=ParameterIn.QUERY), @Parameter(name="username", description="userName of the user to create the new watcher for.", in=ParameterIn.QUERY), @Parameter(name="expand", description="properties to expand on the user.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a user", responseCode=200, representation=Person.class), @ResponseDoc(documentation="Returned if a user with the given username or userkey does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if the calling user does not have permission to view users.", responseCode=403, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Person getUser(@QueryParam(value="key") String key, @QueryParam(value="username") String username, @QueryParam(value="expand") String expand) {
        UserKey userkey;
        UserKey userKey = userkey = !Strings.isNullOrEmpty((String)key) ? new UserKey(key) : null;
        if (userkey == null && Strings.isNullOrEmpty((String)username) || userkey != null && !Strings.isNullOrEmpty((String)username)) {
            throw new BadRequestException("Only one query param of key or username is required");
        }
        PersonService.PersonFinder personFinder = this.personService.find(ExpansionsParser.parse((String)expand));
        if (userkey != null) {
            personFinder.withUserKey(userkey);
        } else {
            personFinder.withUsername(username);
        }
        return (Person)personFinder.fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No user found with key : " + key)));
    }

    @Operation(summary="Get registered users", description="Gets a paginated collection of all registered users, including but not limited to:\n\n- Disabled users\n- Enabled users\n- Enabled users which count towards the license count on the site\n- Enabled users which do not count towards the license count on the site\n- Enabled users which have \"can use\" global permissions\n- Enabled users which do not have \"can use\" global permissions\n\nExample request URI(s):\n\n`http://example.com/confluence/rest/api/user/list`\n`http://example.com/confluence/rest/api/user/list?start=0`\n`http://example.com/confluence/rest/api/user/list?start=0&limit=100`\n`http://example.com/confluence/rest/api/user/list?start=0&limit=100&expand=status`")
    @Parameters(value={@Parameter(name="expand", description="properties to expand on the user.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return. This must be non-negative. Default value is 0.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of users to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a paginated collection of users.", responseCode=200, representation=Person.class, paged=true), @ResponseDoc(documentation="Returned if the calling user does not have permission to view users. This is possible for anonymous or un-licensed users.", responseCode=403, restError=true)})
    @GET
    @Path(value="/list")
    @RateLimited(propertyName="confluence.full.sync.rl.users.rps", permitsPerSecond=10.0, type=RateLimited.Type.TWO_LO)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Person> getUsers(@QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest restPageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse users = this.personService.find(expansions).fetchMany((PageRequest)restPageRequest);
        return RestList.newRestList((PageResponse)users).pageRequest((PageRequest)restPageRequest).build();
    }

    @Operation(summary="Get current user", description="Get information about the current logged in user. Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/current`")
    @Parameter(name="expand", description="properties to expand on the user.", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a user.", responseCode=200, representation=Person.class), @ResponseDoc(documentation="Returned if the calling user does not have permission to use confluence.", responseCode=403, restError=true)})
    @GET
    @Path(value="/current")
    @ScopesAllowed(requiredScope={"READ"})
    public Person getCurrent(@GraphQLExpansionParam @QueryParam(value="expand") String expand) {
        return this.personService.getCurrentUser(ExpansionsParser.parse((String)expand));
    }

    @Operation(summary="Get information about anonymous user type", description="Get information about how anonymous is represented in Confluence. Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/anonymous`")
    @Parameter(name="expand", description="properties to expand on the user.", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a user.", responseCode=200, representation=Person.class), @ResponseDoc(documentation="Returned if the calling user does not have permission to use confluence.", responseCode=403, restError=true)})
    @GET
    @Path(value="/anonymous")
    @ScopesAllowed(requiredScope={"READ"})
    public Person getAnonymous() {
        return (Person)this.personService.find(new Expansion[0]).withUserKey(null).fetchOrNull();
    }

    @Operation(summary="Get groups", description="Get a paginated collection of groups that the given user is a member of. Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/memberof?username=jblogs`\n`http://example.com/confluence/rest/api/user/memberof?key=402880824ff933a4014ff9345d7c0002`")
    @Parameters(value={@Parameter(name="key", description="userkey of the user to request from this resource", in=ParameterIn.QUERY), @Parameter(name="username", description="userName of the user to get the groups for.", in=ParameterIn.QUERY), @Parameter(name="expand", description="properties to expand on the user.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return. This must be non-negative. Default value is 0.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of users to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a user.", responseCode=200, representation=Person.class, paged=true), @ResponseDoc(documentation="Returned if the calling user does not have permission to use confluence.", responseCode=403, restError=true)})
    @GET
    @Path(value="/memberof")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Group> getGroups(@QueryParam(value="key") String userKey, @QueryParam(value="username") String username, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest restPageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Person person = this.getUser(userKey, username, "");
        if (person instanceof User) {
            return RestList.newRestList((PageResponse)this.groupService.find(expansions).withMember((User)person).fetchMany((PageRequest)restPageRequest)).pageRequest((PageRequest)restPageRequest).build();
        }
        throw new NotFoundException(String.format("User cannot belong to a group : %s", person));
    }

    @Operation(summary="Change password", description="Change the password for the current user. \n\n Validation Rules: \n\n- New password supplied cannot be null or blank\n\nExample request URI(s):\n\n`http://example.com/confluence/rest/api/user/current/password`")
    @RequestBody(description="password change details", content={@Content(schema=@Schema(implementation=PasswordChangeDetails.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="returned if the password changed successfully.", responseCode=204), @ResponseDoc(documentation=" returned if any error occurs while changing user password. Refer the validation rules above.", responseCode=400, restError=true), @ResponseDoc(documentation="returned if the user is not authenticated.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if current password is wrong or if the user has exceeded number of allowed failed login attempts\n.", responseCode=403, restError=true)})
    @POST
    @Path(value="/current/password")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response changePassword(PasswordChangeDetails passwordChangeDetails) {
        this.personService.changeMyPassword(passwordChangeDetails);
        return Response.noContent().build();
    }

    @Operation(summary="Update details of the current user", description="Change the current user's details.\n\nValidation Rules:\n- Full name cannot be blank, containing <> characters or be reserved by Confluence.\n- Email must be a valid email address.\n- Current password must be supplied for changing email address.\n\nExample PUT request URI(s):\n`http://example.com/confluence/rest/api/user/current`\n")
    @RequestBody(description="User details", content={@Content(schema=@Schema(implementation=UserDetailsForUpdate.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the update was successful.", responseCode=204), @ResponseDoc(documentation=" Returned if any error occurs while updating user details. Refer the validation rules above.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the user is not authenticated.", responseCode=401, restError=true), @ResponseDoc(documentation="Returned if current password is wrong or if the user has exceeded number of allowed failed login attempts\n.", responseCode=403, restError=true)})
    @PUT
    @Path(value="/current")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateUser(UserDetailsForUpdate userDetailsForUpdate, @Context UriInfo uriInfo) {
        this.personService.update(userDetailsForUpdate);
        return Response.noContent().build();
    }

    @Operation(summary="Update a user's preference settings", description="Update the specified user's settings including their prefered language setting.\n\nValues:\n- Username cannot be blank.\n- The user's locale preference can be removed by setting it to \"None\".\n\nExample PUT request URI(s):\n`http://example.com/confluence/rest/api/user/settings`\n")
    @RequestBody(description="User settings update request", content={@Content(schema=@Schema(implementation=UserSettings.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the settings update was successful.", responseCode=204), @ResponseDoc(documentation="Returned if a error occurs while updating user settings.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the user tries to update settings without appropriate permission.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if the user is not authenticated.", responseCode=401, restError=true)})
    @PUT
    @Path(value="/settings")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    @LicensedOnly
    public Response updateUserSettings(UserSettings userSettings) {
        this.userSettingsService.updateUserSettings(userSettings);
        return Response.noContent().build();
    }
}

