/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.watch.ContentWatch;
import com.atlassian.confluence.api.model.watch.SpaceWatch;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.api.service.watch.WatchService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/user/watch")
@Tag(name="User Watch")
public class UserWatchResource {
    private static final String WATCHING = "watching";
    private final WatchService watchService;
    private final PersonService personService;

    @Inject
    public UserWatchResource(@ComponentImport WatchService watchService, @ComponentImport PersonService personService) {
        this.watchService = watchService;
        this.personService = personService;
    }

    @Operation(summary="Add space watcher", description="Create a new watcher for the given user and space key. User is optional. If not specified, currently logged-in user will be used. Otherwise, it can be specified by either user key or username. When a user is specified and is different from the logged-in user, the logged-in user needs to be a Confluence administrator. \n\n Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?username=jblogs`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?key=ff8080815a58e24c015a58e263710000`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?contentType=blogpost`")
    @Parameters(value={@Parameter(name="key", description="userKey of the user to create the new watcher for.", in=ParameterIn.QUERY), @Parameter(name="username", description="userName of the user to create the new watcher for.", in=ParameterIn.QUERY), @Parameter(name="contentType", description="the optional content type to delete the watcher for.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the watcher was successfully created", responseCode=200, representation=SpaceWatch.class), @ResponseDoc(documentation="Returned if no content exists for the specified space key or the calling user does not have permission to perform the operation", responseCode=404, restError=true)})
    @POST
    @Path(value="/space/{spaceKey}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public SpaceWatch addSpaceWatch(@QueryParam(value="key") UserKey key, @QueryParam(value="username") String username, @QueryParam(value="contentType") List<ContentType> contentTypes, @PathParam(value="spaceKey") String spaceKey) throws ServiceException {
        UserKey watcher = this.figureOutWatcher(key, username);
        return this.watchService.watchSpace(watcher, spaceKey, (List)(contentTypes != null ? contentTypes : new ArrayList()));
    }

    @Operation(summary="Remove space watcher", description="Delete an existing watcher for the given user and space key. User is optional. If not specified, currently logged-in user will be used. Otherwise, it can be specified by either user key or username. When a user is specified and is different from the logged-in user, the logged-in user needs to be a Confluence administrator. \n\n Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?username=jblogs`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?key=ff8080815a58e24c015a58e263710000`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?contentType=blogpost`")
    @Parameters(value={@Parameter(name="key", description="userkey of the user to delete the watcher for.", in=ParameterIn.QUERY), @Parameter(name="username", description="username of the user to delete the watcher for.", in=ParameterIn.QUERY), @Parameter(name="contentType", description="the optional content type to delete the watcher for.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the watcher was successfully deleted", responseCode=204), @ResponseDoc(documentation="Returned if no content exists for the specified space key or the calling user does not have permission to perform the operation", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/space/{spaceKey}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response removeSpaceWatch(@QueryParam(value="key") UserKey key, @QueryParam(value="username") String username, @QueryParam(value="contentType") List<ContentType> contentTypes, @PathParam(value="spaceKey") String spaceKey) throws ServiceException {
        UserKey watcher = this.figureOutWatcher(key, username);
        this.watchService.unwatchSpace(watcher, spaceKey, (List)(contentTypes != null ? contentTypes : new ArrayList()));
        return Response.noContent().build();
    }

    @Operation(summary="Get information about space watcher", description="Get information about whether a user is watching a specified space. User is optional. If not specified, currently logged-in user will be used. Otherwise, it can be specified by either user key or username. When a user is specified and is different from the logged-in user, the logged-in user needs to be a Confluence administrator. \n\n Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?username=jblogs`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?key=ff8080815a58e24c015a58e263710000`\n`http://example.com/confluence/rest/api/user/watch/space/SPACEKEY?contentType=blostpost`")
    @Parameters(value={@Parameter(name="key", description="userkey of the user to check for watching state.", in=ParameterIn.QUERY), @Parameter(name="username", description="username of the user to check for watching state.", in=ParameterIn.QUERY), @Parameter(name="contentType", description="an optional content type to check for watching state.", in=ParameterIn.QUERY)})
    @ApiResponse(responseCode="200", description="Returns a JSON representation containing the watching state.", content={@Content(examples={@ExampleObject(name="watching", value="true")})})
    @ResponseDoc(documentation="Returned if no space exists for the specified space key or the calling user does not have permission to perform the operation.", responseCode=404, restError=true)
    @GET
    @Path(value="/space/{spaceKey}")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public Response isWatchingSpace(@QueryParam(value="key") UserKey key, @QueryParam(value="username") String username, @QueryParam(value="contentType") ContentType contentType, @PathParam(value="spaceKey") String spaceKey) throws ServiceException {
        UserKey watcher = this.figureOutWatcher(key, username);
        boolean watching = contentType != null ? this.watchService.isWatchingSpace(watcher, spaceKey, contentType) : this.watchService.isWatchingSpace(watcher, spaceKey);
        return Response.ok(Collections.singletonMap(WATCHING, watching)).build();
    }

    @Operation(summary="Add content watcher", description="Create a new watcher for the given user and content id. User is optional. If not specified, currently logged-in user will be used. Otherwise, it can be specified by either user key or username. When a user is specified and is different from the logged-in user, the logged-in user needs to be a Confluence administrator. \n\n Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/watch/content/131213`\n`http://example.com/confluence/rest/api/user/watch/content/131213?username=jblogs`\n`http://example.com/confluence/rest/api/user/watch/content/131213?key=ff8080815a58e24c015a58e263710000`")
    @Parameters(value={@Parameter(name="contentId", description="id of the content.", in=ParameterIn.PATH), @Parameter(name="key", description="userkey of the user to check for watching state.", in=ParameterIn.QUERY), @Parameter(name="username", description="username of the user to check for watching state.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the watcher was successfully created.", responseCode=200, representation=ContentWatch.class), @ResponseDoc(documentation="Returned if no content exists for the specified content id or the calling user does not have permission to perform the operation.", responseCode=404, restError=true)})
    @POST
    @Path(value="/content/{contentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public ContentWatch addContentWatcher(@QueryParam(value="key") UserKey key, @QueryParam(value="username") String username, @PathParam(value="contentId") ContentId contentId) throws ServiceException {
        UserKey watcher = this.figureOutWatcher(key, username);
        return this.watchService.watchContent(watcher, contentId);
    }

    @Operation(summary="Remove content watcher", description="Delete an existing watcher for the given user and content id. User is optional. If not specified, currently logged-in user will be used. Otherwise, it can be specified by either user key or username. When a user is specified and is different from the logged-in user, the logged-in user needs to be a Confluence administrator. \n\n Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/watch/content/131213`\n`http://example.com/confluence/rest/api/user/watch/content/131213?username=jblogs`\n`http://example.com/confluence/rest/api/user/watch/content/131213?key=ff8080815a58e24c015a58e263710000`")
    @Parameters(value={@Parameter(name="contentId", description="id of the content.", in=ParameterIn.PATH), @Parameter(name="key", description="userkey of the user to check for watching state.", in=ParameterIn.QUERY), @Parameter(name="username", description="username of the user to check for watching state.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the watcher was successfully deleted", responseCode=204), @ResponseDoc(documentation="Returned if no content exists for the specified content id or the calling user does not have permission to perform the operation", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/content/{contentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response removeContentWatcher(@QueryParam(value="key") UserKey key, @QueryParam(value="username") String username, @PathParam(value="contentId") ContentId contentId) throws ServiceException {
        UserKey watcher = this.figureOutWatcher(key, username);
        this.watchService.unwatchContent(watcher, contentId);
        return Response.noContent().build();
    }

    @Operation(summary="Get information about content watcher", description="Get information about whether a user is watching a specified content. User is optional. If not specified, currently logged-in user will be used. Otherwise, it can be specified by either user key or username. When a user is specified and is different from the logged-in user, the logged-in user needs to be a Confluence administrator. \n\n Example request URI(s):\n\n`http://example.com/confluence/rest/api/user/watch/content/131213`\n`http://example.com/confluence/rest/api/user/watch/content/131213?username=jblogs`\n`http://example.com/confluence/rest/api/user/watch/content/131213?key=ff8080815a58e24c015a58e263710000`")
    @Parameters(value={@Parameter(name="contentId", description="id of the content.", in=ParameterIn.PATH), @Parameter(name="key", description="userkey of the user to check for watching state.", in=ParameterIn.QUERY), @Parameter(name="username", description="username of the user to check for watching state.", in=ParameterIn.QUERY)})
    @ApiResponse(responseCode="200", description="Returns a JSON representation containing the watching state.", content={@Content(examples={@ExampleObject(name="watching", value="true")})})
    @ResponseDoc(documentation="Returned if no content exists for the specified content id or calling user does not have permission to perform the operation", responseCode=404, restError=true)
    @GET
    @Path(value="/content/{contentId}")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public Response isWatchingContent(@QueryParam(value="key") UserKey key, @QueryParam(value="username") String username, @PathParam(value="contentId") ContentId contentId) throws ServiceException {
        UserKey watcher = this.figureOutWatcher(key, username);
        boolean value = this.watchService.isWatchingContent(watcher, contentId);
        return Response.ok(Collections.singletonMap(WATCHING, value)).build();
    }

    private UserKey figureOutWatcher(@Nullable UserKey key, @Nullable String username) {
        Person watcher;
        if (key != null && StringUtils.isNotEmpty((CharSequence)username)) {
            throw new BadRequestException("Only one query param of key or username (or none) is allowed");
        }
        PersonService.PersonFinder personFinder = this.personService.find(new Expansion[0]);
        if (key != null) {
            personFinder.withUserKey(key);
            watcher = (Person)personFinder.fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No user found with key :" + String.valueOf(key))));
        } else if (username != null) {
            personFinder.withUsername(username);
            watcher = (Person)personFinder.fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No user found with username :" + username)));
        } else {
            watcher = this.personService.getCurrentUser(new Expansion[0]);
        }
        return (UserKey)watcher.optionalUserKey().orElseThrow(ServiceExceptionSupplier.notFound((String)"User doesn't have a userKey"));
    }
}

