/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources.util;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MockRestrictionsResponse {
    @Schema(description="Map of operation to OperationRestriction, representing the restrictions by operation", example="{\n  \"read\": {\n    \"operation\": \"read\",\n    \"restrictions\": {\n      \"user\": {\"results\": [], \"start\": 0, \"limit\": 200, \"size\": 0},\n      \"group\": {\"results\": [], \"start\": 0, \"limit\": 200, \"size\": 0}\n    },\n    \"_links\": {\n      \"self\": \"https://instenv-320828-cq6e.instenv.internal.atlassian.com/rest/api/content/2326529/restriction/byOperation/read\"\n    },\n    \"_expandable\": {\n      \"content\": \"/rest/api/content/2326529\"\n    }\n  },\n  \"update\": {\n    \"operation\": \"update\",\n    \"restrictions\": {\n      \"user\": {\"results\": [], \"start\": 0, \"limit\": 200, \"size\": 0},\n      \"group\": {\"results\": [], \"start\": 0, \"limit\": 200, \"size\": 0}\n    },\n    \"_links\": {\n      \"self\": \"https://instenv-320828-cq6e.instenv.internal.atlassian.com/rest/api/content/2326529/restriction/byOperation/update\"\n    },\n    \"_expandable\": {\n      \"content\": \"/rest/api/content/2326529\"\n    }\n  }\n}\n")
    private Map<String, OperationRestriction> restrictions;
    private Links _links;

    public Map<String, OperationRestriction> getRestrictions() {
        return Collections.unmodifiableMap(this.restrictions);
    }

    public Links get_links() {
        return this._links;
    }

    private static class Links {
        @Schema(description="Self link", example="https://instenv-320828-cq6e.instenv.internal.atlassian.com/rest/api/content/2326529/restriction/byOperation/read")
        private String self;
        @Schema(description="Base link", example="https://instenv-320828-cq6e.instenv.internal.atlassian.com")
        private String base;
        @Schema(description="Context link", example="")
        private String context;

        private Links() {
        }

        public String getSelf() {
            return this.self;
        }

        public String getBase() {
            return this.base;
        }

        public String getContext() {
            return this.context;
        }
    }

    private static class Expandable {
        @Schema(description="Content link", example="/rest/api/content/2326529")
        private String content;

        private Expandable() {
        }

        public String getContent() {
            return this.content;
        }
    }

    private static class PageResponse<T> {
        @Schema(description="Results of the page response", example="[]")
        private List<T> results;
        @Schema(description="Start index of the page response", example="0")
        private int start;
        @Schema(description="Limit of the page response", example="200")
        private int limit;
        @Schema(description="Size of the results", example="0")
        private int size;

        private PageResponse() {
        }

        public List<T> getResults() {
            return this.results;
        }

        public int getStart() {
            return this.start;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static class Restrictions {
        @Schema(description="Restrictions for users", example="{\"results\": [], \"start\": 0, \"limit\": 200, \"size\": 0}")
        private PageResponse<Object> user;
        @Schema(description="Restrictions for groups", example="{\"results\": [], \"start\": 0, \"limit\": 200, \"size\": 0}")
        private PageResponse<Object> group;

        private Restrictions() {
        }

        public PageResponse<Object> getUser() {
            return this.user;
        }

        public PageResponse<Object> getGroup() {
            return this.group;
        }
    }

    public static class OperationRestriction {
        @Schema(description="The operation type", example="read")
        private String operation;
        private Restrictions restrictions;
        private Links _links;
        private Expandable _expandable;

        public String getOperation() {
            return this.operation;
        }

        public Restrictions getRestrictions() {
            return this.restrictions;
        }

        public void setRestrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
        }

        public Links get_links() {
            return this._links;
        }

        public Expandable get_expandable() {
            return this._expandable;
        }
    }
}

