/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl.stream;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.pocketknife.api.querydsl.stream.CloseableIterable;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.Expression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@Internal
public class PartitionedCloseableIterable<T>
implements CloseableIterable<T> {
    private final List<CloseableIterable<T>> iterables;

    public PartitionedCloseableIterable(List<CloseableIterable<T>> iterables) {
        this.iterables = iterables == null ? Collections.emptyList() : List.copyOf(iterables);
    }

    @Override
    public CloseableIterator<T> iterator() {
        return new PartitionedCloseableIterator(this.iterables.stream().map(CloseableIterable::iterator).toList());
    }

    @Override
    public Optional<T> fetchFirst() {
        try {
            Optional optional = this.iterables.stream().findFirst().flatMap(CloseableIterable::fetchFirst);
            return optional;
        }
        finally {
            this.close();
        }
    }

    @Override
    public CloseableIterable<T> take(int n) {
        ArrayList<CloseableIterable<T>> newIterables = new ArrayList<CloseableIterable<T>>();
        AtomicInteger count = new AtomicInteger(0);
        for (CloseableIterable<Object> closeableIterable : this.iterables) {
            newIterables.add(closeableIterable.takeWhile(t -> count.getAndIncrement() < n));
        }
        return new PartitionedCloseableIterable<T>(newIterables);
    }

    @Override
    public CloseableIterable<T> takeWhile(Predicate<T> takeWhilePredicate) {
        ArrayList<CloseableIterable<T>> newIterables = new ArrayList<CloseableIterable<T>>();
        AtomicBoolean ok = new AtomicBoolean(true);
        for (CloseableIterable<Object> closeableIterable : this.iterables) {
            newIterables.add(closeableIterable.takeWhile(t -> {
                if (ok.get()) {
                    ok.set(takeWhilePredicate.test(t));
                }
                return ok.get();
            }));
        }
        return new PartitionedCloseableIterable<T>(newIterables);
    }

    @Override
    public CloseableIterable<T> filter(Predicate<T> filterPredicate) {
        ArrayList<CloseableIterable<T>> newIterables = new ArrayList<CloseableIterable<T>>();
        for (CloseableIterable<T> iterable : this.iterables) {
            newIterables.add(iterable.filter(filterPredicate));
        }
        return new PartitionedCloseableIterable<T>(newIterables);
    }

    @Override
    public <D> CloseableIterable<D> map(Function<T, D> mapper) {
        ArrayList<CloseableIterable<T>> newIterables = new ArrayList<CloseableIterable<T>>();
        for (CloseableIterable<T> iterable : this.iterables) {
            newIterables.add(iterable.map(mapper));
        }
        return new PartitionedCloseableIterable<T>(newIterables);
    }

    @Override
    public <D> CloseableIterable<D> map(Expression<D> expr) {
        ArrayList<CloseableIterable<T>> newIterables = new ArrayList<CloseableIterable<T>>();
        for (CloseableIterable<T> iterable : this.iterables) {
            newIterables.add(iterable.map(expr));
        }
        return new PartitionedCloseableIterable<T>(newIterables);
    }

    @Override
    public <D> D foldLeft(D initial, BiFunction<D, T, D> combiningFunction) {
        D value = initial;
        for (CloseableIterable<T> iterable : this.iterables) {
            value = iterable.foldLeft(value, combiningFunction);
        }
        return value;
    }

    @Override
    public void foreach(Consumer<T> effect) {
        this.iterables.forEach(i -> i.foreach(effect));
    }

    @Override
    public void close() {
        this.iterables.forEach(CloseableIterable::close);
    }

    @VisibleForTesting
    static class PartitionedCloseableIterator<T>
    implements CloseableIterator<T> {
        private final List<CloseableIterator<T>> iterators;

        PartitionedCloseableIterator(List<CloseableIterator<T>> iterators) {
            this.iterators = iterators == null ? Collections.emptyList() : List.copyOf(iterators);
        }

        @Override
        public void close() {
            this.iterators.forEach(CloseableIterator::close);
        }

        @Override
        public boolean hasNext() {
            return this.iterators.stream().anyMatch(Iterator::hasNext);
        }

        @Override
        public T next() {
            Optional<CloseableIterator> first = this.iterators.stream().filter(Iterator::hasNext).findFirst();
            if (first.isPresent()) {
                return (T)first.get().next();
            }
            throw new NoSuchElementException();
        }
    }
}

