/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.internal.crowd;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.component.CrowdComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.CrowdImport;
import com.atlassian.ratelimiting.cluster.ClusterEventService;
import com.atlassian.ratelimiting.configuration.SystemPropertiesService;
import com.atlassian.ratelimiting.dao.UserRateLimitSettingsDao;
import com.atlassian.ratelimiting.featureflag.RateLimitingFeatureFlagService;
import com.atlassian.ratelimiting.internal.settings.RateLimitModificationSettingsService;
import com.atlassian.ratelimiting.license.LicenseChecker;
import com.atlassian.ratelimiting.user.UserService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CrowdComponent
@ExportAsService(value={LifecycleAware.class})
public class CrowdRateLimitModificationSettingsService
extends RateLimitModificationSettingsService {
    public static final String PLUGIN_KEY = "com.atlassian.ratelimiting.rate-limiting-plugin";
    public static final Long DEFAULT_EXEMPTIONS_LIMIT = 50000L;
    public static final String HSQLDB = "jdbc:hsqldb";
    private final AtlassianBootstrapManager bootstrapManager;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private static final Logger logger = LoggerFactory.getLogger(CrowdRateLimitModificationSettingsService.class);

    public CrowdRateLimitModificationSettingsService(UserRateLimitSettingsDao userSettingsDao, SystemPropertiesService systemPropertiesService, EventPublisher eventPublisher, UserService userService, ClusterEventService clusterEventService, LicenseChecker licenseChecker, RateLimitingFeatureFlagService rateLimitingFeatureFlagService, ActiveObjects activeObjects, @CrowdImport AtlassianBootstrapManager bootstrapManager, @CrowdImport PluginAccessor pluginAccessor, @CrowdImport PluginController pluginController) {
        super(userSettingsDao, userService, systemPropertiesService, eventPublisher, clusterEventService, licenseChecker, rateLimitingFeatureFlagService, activeObjects, DEFAULT_EXEMPTIONS_LIMIT);
        this.bootstrapManager = bootstrapManager;
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
    }

    @Override
    @PostConstruct
    public void afterPropertiesSet() {
        try {
            boolean hsqldbDetected = String.valueOf(this.bootstrapManager.getApplicationConfig().getProperty((Object)"hibernate.connection.url")).contains(HSQLDB);
            if (hsqldbDetected) {
                logger.warn("Rate limiting plugin is not yet supported on HSQLDB. Uninstalling plugin.");
                this.pluginController.uninstall(this.pluginAccessor.getPlugin(PLUGIN_KEY));
            }
        }
        catch (Exception e) {
            logger.warn("Error while checking for HSQLDB", (Throwable)e);
        }
    }
}

