/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.search.query.entity.ApplicationQuery;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.ApplicationTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.component.CrowdComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.CrowdImport;
import com.atlassian.ratelimiting.internal.user.CrowdUserService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@CrowdComponent
public class CrowdUserAppService
extends CrowdUserService {
    private final ApplicationManager applicationManager;
    private final ApplicationProperties applicationProperties;

    public CrowdUserAppService(@CrowdImport UserManager userManager, @CrowdImport CrowdService crowdService, @CrowdImport ApplicationManager applicationManager, @CrowdImport ApplicationProperties applicationProperties) {
        super(userManager, crowdService);
        this.applicationManager = applicationManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public Optional<UserProfile> getUser(UserKey userKey) {
        return this.getUser(userKey.getStringValue());
    }

    @Override
    public UserKey getUserKey(HttpServletRequest request) {
        Object attr;
        HttpSession session = request.getSession(false);
        if (session != null && (attr = session.getAttribute("com.atlassian.crowd.authenticated.application.name")) != null) {
            return new UserKey(String.valueOf(attr.toString()));
        }
        return super.getUserKey(request);
    }

    @Override
    public Optional<UserProfile> getUser(String userName) {
        try {
            return Optional.of(this.crowdAppToSalUser(this.applicationManager.findByName(userName)));
        }
        catch (ApplicationNotFoundException notAnApp) {
            return Optional.ofNullable(this.userManager.getUserProfile(userName));
        }
    }

    @Override
    public List<UserProfile> searchUsersForUserPicker(String criteria, int offset, int maxNumberOfResults) {
        ArrayList<UserProfile> searchResults = new ArrayList<UserProfile>();
        ApplicationQuery appQuery = new ApplicationQuery(CrowdUserAppService.createAppSearchRestriction(criteria), offset, maxNumberOfResults);
        this.applicationManager.search((EntityQuery)appQuery).stream().map(this::crowdAppToSalUser).forEach(searchResults::add);
        searchResults.addAll(super.searchUsersForUserPicker(criteria, Math.max(0, offset - searchResults.size()), Math.max(0, maxNumberOfResults - searchResults.size())));
        return searchResults;
    }

    protected static SearchRestriction createAppSearchRestriction(String name) {
        return Strings.isNullOrEmpty((String)name) ? NullRestrictionImpl.INSTANCE : new TermRestriction(ApplicationTermKeys.NAME, MatchMode.CONTAINS, (Object)name);
    }

    private UserProfile crowdAppToSalUser(Application crowdApp) {
        return new CrowdAppProfile(crowdApp);
    }

    class CrowdAppProfile
    implements UserProfile {
        private final UserKey userKey;
        private final String userName;
        private URI profilePictureUri;

        private CrowdAppProfile(Application application) {
            this.userKey = new UserKey(application.getName());
            this.userName = application.getName();
            try {
                this.profilePictureUri = new URI(CrowdUserAppService.this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/rest/rate-limiting/latest/users/app-icon?type=" + application.getType().name());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }

        public UserKey getUserKey() {
            return this.userKey;
        }

        public String getUsername() {
            return this.userName;
        }

        public String getFullName() {
            return this.userName;
        }

        public String getEmail() {
            return null;
        }

        public URI getProfilePictureUri(int width, int height) {
            return null;
        }

        public URI getProfilePictureUri() {
            return this.profilePictureUri;
        }

        public URI getProfilePageUri() {
            return null;
        }
    }
}

