/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.internal.requesthandler;

import com.atlassian.ratelimiting.featureflag.RateLimitingFeatureFlagService;
import com.atlassian.ratelimiting.requesthandler.RateLimitOAuth2ClientCredentialsRequestHandler;
import jakarta.servlet.http.HttpServletRequest;

public class DefaultOAuth2ClientCredentialsRequestRateLimitHandler
implements RateLimitOAuth2ClientCredentialsRequestHandler {
    public static final String OAUTH2_ATTRIBUTE_KEY_CLIENT_CONFIG_ID = "oauth2.token.client_configuration_id";
    public static final String OAUTH2_ATTRIBUTE_KEY_CLIENT_ID = "oauth2.token.client_id";
    private final RateLimitingFeatureFlagService rateLimitingFeatureFlagService;

    public DefaultOAuth2ClientCredentialsRequestRateLimitHandler(RateLimitingFeatureFlagService rateLimitingFeatureFlagService) {
        this.rateLimitingFeatureFlagService = rateLimitingFeatureFlagService;
    }

    @Override
    public boolean shouldApplyRateLimiting(HttpServletRequest request) {
        return this.isOAuth2RateLimitingEnabled() && DefaultOAuth2ClientCredentialsRequestRateLimitHandler.isOAuth2ClientCredentialsRequest(request);
    }

    private boolean isOAuth2RateLimitingEnabled() {
        return this.rateLimitingFeatureFlagService.isOAuth2RateLimitingEnabled();
    }

    static boolean isOAuth2ClientCredentialsRequest(HttpServletRequest request) {
        return request.getAttribute(OAUTH2_ATTRIBUTE_KEY_CLIENT_CONFIG_ID) != null;
    }
}

