/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.rest.api;

import com.atlassian.ratelimiting.dmz.UserRateLimitSettings;
import com.atlassian.ratelimiting.rest.api.RestTokenBucketSettings;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class RestOAuth2ClientCredentialsRateLimitSettings {
    private String clientId;
    private boolean whitelisted;
    private boolean blacklisted;
    private RestTokenBucketSettings settings;

    public RestOAuth2ClientCredentialsRateLimitSettings(UserRateLimitSettings userRateLimitSettings, String clientId) {
        this.populateClientCredentialsSettings(userRateLimitSettings);
        this.clientId = clientId;
    }

    private void populateClientCredentialsSettings(UserRateLimitSettings userRateLimitSettings) {
        if (userRateLimitSettings.isWhitelisted()) {
            this.whitelisted = true;
        } else if (userRateLimitSettings.isBlacklisted()) {
            this.blacklisted = true;
        } else {
            this.settings = userRateLimitSettings.getSettings().map(RestTokenBucketSettings::new).orElse(null);
        }
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    @Generated
    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    @Generated
    public RestTokenBucketSettings getSettings() {
        return this.settings;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setWhitelisted(boolean whitelisted) {
        this.whitelisted = whitelisted;
    }

    @Generated
    public void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    @Generated
    public void setSettings(RestTokenBucketSettings settings) {
        this.settings = settings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestOAuth2ClientCredentialsRateLimitSettings)) {
            return false;
        }
        RestOAuth2ClientCredentialsRateLimitSettings other = (RestOAuth2ClientCredentialsRateLimitSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWhitelisted() != other.isWhitelisted()) {
            return false;
        }
        if (this.isBlacklisted() != other.isBlacklisted()) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        RestTokenBucketSettings this$settings = this.getSettings();
        RestTokenBucketSettings other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestOAuth2ClientCredentialsRateLimitSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWhitelisted() ? 79 : 97);
        result = result * 59 + (this.isBlacklisted() ? 79 : 97);
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        RestTokenBucketSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestOAuth2ClientCredentialsRateLimitSettings(clientId=" + this.getClientId() + ", whitelisted=" + this.isWhitelisted() + ", blacklisted=" + this.isBlacklisted() + ", settings=" + String.valueOf(this.getSettings()) + ")";
    }

    @Generated
    public RestOAuth2ClientCredentialsRateLimitSettings(String clientId, boolean whitelisted, boolean blacklisted, RestTokenBucketSettings settings) {
        this.clientId = clientId;
        this.whitelisted = whitelisted;
        this.blacklisted = blacklisted;
        this.settings = settings;
    }

    @Generated
    public RestOAuth2ClientCredentialsRateLimitSettings() {
    }
}

