/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.rest.api;

import com.atlassian.ratelimiting.history.UserRateLimitingReport;
import com.atlassian.ratelimiting.rest.api.RestApplicationUser;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.ZoneOffset;
import java.util.Date;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize
public class RestUserRateLimitingReport {
    private RestApplicationUser user;
    private Long rejectCount;
    private Date lastRejectTime;
    private Boolean hasExemption;

    public RestUserRateLimitingReport(UserRateLimitingReport userRateLimitingReport, UserProfile userProfile) {
        this.user = new RestApplicationUser(userProfile);
        this.rejectCount = userRateLimitingReport.getRejectCount();
        this.lastRejectTime = Date.from(userRateLimitingReport.getLastRejectedTime().atZone(ZoneOffset.UTC).toInstant());
        this.hasExemption = userRateLimitingReport.isHasExemption();
    }

    @Generated
    public RestApplicationUser getUser() {
        return this.user;
    }

    @Generated
    public Long getRejectCount() {
        return this.rejectCount;
    }

    @Generated
    public Date getLastRejectTime() {
        return this.lastRejectTime;
    }

    @Generated
    public Boolean getHasExemption() {
        return this.hasExemption;
    }

    @Generated
    public void setUser(RestApplicationUser user) {
        this.user = user;
    }

    @Generated
    public void setRejectCount(Long rejectCount) {
        this.rejectCount = rejectCount;
    }

    @Generated
    public void setLastRejectTime(Date lastRejectTime) {
        this.lastRejectTime = lastRejectTime;
    }

    @Generated
    public void setHasExemption(Boolean hasExemption) {
        this.hasExemption = hasExemption;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestUserRateLimitingReport)) {
            return false;
        }
        RestUserRateLimitingReport other = (RestUserRateLimitingReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$rejectCount = this.getRejectCount();
        Long other$rejectCount = other.getRejectCount();
        if (this$rejectCount == null ? other$rejectCount != null : !((Object)this$rejectCount).equals(other$rejectCount)) {
            return false;
        }
        Boolean this$hasExemption = this.getHasExemption();
        Boolean other$hasExemption = other.getHasExemption();
        if (this$hasExemption == null ? other$hasExemption != null : !((Object)this$hasExemption).equals(other$hasExemption)) {
            return false;
        }
        RestApplicationUser this$user = this.getUser();
        RestApplicationUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Date this$lastRejectTime = this.getLastRejectTime();
        Date other$lastRejectTime = other.getLastRejectTime();
        return !(this$lastRejectTime == null ? other$lastRejectTime != null : !((Object)this$lastRejectTime).equals(other$lastRejectTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestUserRateLimitingReport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $rejectCount = this.getRejectCount();
        result = result * 59 + ($rejectCount == null ? 43 : ((Object)$rejectCount).hashCode());
        Boolean $hasExemption = this.getHasExemption();
        result = result * 59 + ($hasExemption == null ? 43 : ((Object)$hasExemption).hashCode());
        RestApplicationUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Date $lastRejectTime = this.getLastRejectTime();
        result = result * 59 + ($lastRejectTime == null ? 43 : ((Object)$lastRejectTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestUserRateLimitingReport(user=" + String.valueOf(this.getUser()) + ", rejectCount=" + this.getRejectCount() + ", lastRejectTime=" + String.valueOf(this.getLastRejectTime()) + ", hasExemption=" + this.getHasExemption() + ")";
    }

    @Generated
    public RestUserRateLimitingReport() {
    }
}

