/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.rest.resource;

import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.ratelimiting.dmz.DmzRateLimitSettingsModificationService;
import com.atlassian.ratelimiting.rest.api.RestAnonymousUserRateLimitSettingsUpdateRequest;
import com.atlassian.ratelimiting.rest.api.RestBulkUserRateLimitSettingsUpdateRequest;
import com.atlassian.ratelimiting.rest.resource.AbstractUserRateLimitSettingsResource;
import com.atlassian.ratelimiting.user.UserService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;

@SystemAdminOnly
@Path(value="admin/rate-limit/settings/users/anonymous")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class AnonymousUserRateLimitSettingsResource
extends AbstractUserRateLimitSettingsResource {
    @Inject
    public AnonymousUserRateLimitSettingsResource(I18nResolver i18nService, DmzRateLimitSettingsModificationService rateLimitSettingsService, UserService userService, PermissionEnforcer permissionEnforcer) {
        super(i18nService, rateLimitSettingsService, userService, permissionEnforcer);
    }

    @GET
    public Response getSettings() {
        return super.getSettings("rate_limiting_anonymous_user-67d5362d-3b2f-4531-9039-5f041bdd402a");
    }

    @PUT
    @Path(value="/token-bucket")
    public Response updateSettingsForAnonymousUser(RestAnonymousUserRateLimitSettingsUpdateRequest request) {
        return super.updateSettingsForMultipleUsers(RestBulkUserRateLimitSettingsUpdateRequest.builder().userIds(Collections.singletonList("rate_limiting_anonymous_user-67d5362d-3b2f-4531-9039-5f041bdd402a")).tokenBucketSettings(request.getTokenBucketSettings()).build());
    }

    @PUT
    @Path(value="/whitelist")
    public Response whitelistMultipleUsers() {
        return super.whitelistMultipleUsers(Collections.singleton("rate_limiting_anonymous_user-67d5362d-3b2f-4531-9039-5f041bdd402a"));
    }

    @PUT
    @Path(value="/blacklist")
    public Response blacklistMultipleUsers() {
        return super.blacklistMultipleUsers(Collections.singleton("rate_limiting_anonymous_user-67d5362d-3b2f-4531-9039-5f041bdd402a"));
    }

    @DELETE
    public Response deleteSettings() {
        return super.deleteSettings("rate_limiting_anonymous_user-67d5362d-3b2f-4531-9039-5f041bdd402a");
    }
}

