/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.rest.resource;

import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.ratelimiting.dmz.DmzRateLimitSettingsModificationService;
import com.atlassian.ratelimiting.rest.api.RestBulkClientCredentialsRateLimitSettingsUpdateRequest;
import com.atlassian.ratelimiting.rest.resource.AbstractUserRateLimitSettingsResource;
import com.atlassian.ratelimiting.user.UserService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@SystemAdminOnly
@Path(value="admin/rate-limit/settings/oauth2/client-credentials")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class OAuth2ClientCredentialsRateLimitSettingsResource
extends AbstractUserRateLimitSettingsResource {
    @Inject
    public OAuth2ClientCredentialsRateLimitSettingsResource(I18nResolver i18nService, DmzRateLimitSettingsModificationService rateLimitSettingsService, UserService userService, PermissionEnforcer permissionEnforcer) {
        super(i18nService, rateLimitSettingsService, userService, permissionEnforcer);
    }

    @Override
    @GET
    @Path(value="/{clientId}")
    public Response getSettings(@PathParam(value="clientId") String clientId) {
        return super.getClientCredentialsSettings(clientId);
    }

    @PUT
    @Path(value="/token-bucket")
    public Response updateSettingsForMultipleClients(RestBulkClientCredentialsRateLimitSettingsUpdateRequest request) {
        return super.updateSettingsForMultipleClientCredentialClients(request);
    }

    @PUT
    @Path(value="/whitelist")
    public Response whitelistMultipleClients(Set<String> clientIds) {
        return super.whitelistMultipleClientCredentials(clientIds);
    }

    @PUT
    @Path(value="/blacklist")
    public Response blacklistMultipleClients(Set<String> clientIds) {
        return super.blacklistMultipleClientCredentials(clientIds);
    }

    @Override
    @DELETE
    @Path(value="/{clientId}")
    public Response deleteSettings(@PathParam(value="clientId") String clientId) {
        return super.deleteClientCredentialSettings(clientId);
    }
}

