/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.rest.resource;

import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.ratelimiting.rest.api.RestApplicationUser;
import com.atlassian.ratelimiting.user.UserService;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;

@AdminOnly
@Path(value="admin/rate-limit/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class UserResource {
    private final UserService userService;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public UserResource(UserService userService, PermissionEnforcer permissionEnforcer) {
        this.userService = userService;
        this.permissionEnforcer = permissionEnforcer;
    }

    @GET
    @Path(value="/picker")
    public Response getUsersForUserPicker(@QueryParam(value="filter") String filter, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="10") @QueryParam(value="maxResults") int maxResults) {
        this.permissionEnforcer.enforceAdmin();
        List<UserProfile> searchResults = this.userService.searchUsersForUserPicker(filter, offset, maxResults);
        List mappedSearchResults = searchResults.stream().map(RestApplicationUser::new).collect(Collectors.toList());
        return Response.ok(mappedSearchResults).build();
    }
}

