/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.velocity;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.util.FileAllowlistHelper;
import org.apache.velocity.runtime.resource.loader.util.FileTypeAllowlistHelper;
import org.apache.velocity.runtime.util.ConfigUtil;
import org.apache.velocity.util.ClassUtils;

public class CustomResourceLoader
extends ClasspathResourceLoader {
    private FileAllowlistHelper fileAllowlistHelper = null;
    private FileTypeAllowlistHelper fileTypeAllowlistHelper = null;
    private List<String> trustedResourceProtocols = null;

    public void init(ExtendedProperties extendedProperties) {
        this.fileAllowlistHelper = new FileAllowlistHelper(this.rsvc);
        this.fileTypeAllowlistHelper = new FileTypeAllowlistHelper(this.rsvc, "classpath.resource.loader.filetype.allowlist");
        this.trustedResourceProtocols = ConfigUtil.getStrings((RuntimeServices)this.rsvc, (String)"resource.loader.trusted.protocols");
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream result = null;
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        URL resourceUrl = ClassUtils.getResource(((Object)((Object)this)).getClass(), (String)name);
        if (!this.trustedResourceProtocols.contains(resourceUrl.getProtocol())) {
            if (!this.fileTypeAllowlistHelper.isValidFileType(name)) {
                throw new ResourceNotFoundException("CustomResourceLoader : banned file type on template " + name);
            }
            if (!this.fileAllowlistHelper.isAllowed(name)) {
                throw new ResourceNotFoundException("CustomResourceLoader : This template is not allowed: " + name);
            }
        }
        result = ClassUtils.getResourceAsStream(((Object)((Object)this)).getClass(), (String)name);
        return result;
    }
}

