/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.mentions.NotificationDataService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import org.apache.commons.lang3.StringUtils;

public class NotificationDataServiceImpl
implements NotificationDataService {
    private final DataSourceFactory imageDataSourceFactory;
    private final GlobalSettingsManager globalSettingsManager;

    public NotificationDataServiceImpl(DataSourceFactory imageDataSourceFactory, GlobalSettingsManager globalSettingsManager) {
        this.imageDataSourceFactory = imageDataSourceFactory;
        this.globalSettingsManager = globalSettingsManager;
    }

    @Override
    public NotificationData prepareDecorationContext(ConfluenceUser user, ContentEntityObject contentEntityObject) {
        NotificationData notificationData = new NotificationData((User)user, true, null);
        NotificationContext context = notificationData.getCommonContext();
        context.setActor((User)user);
        context.setAction("mention");
        context.setContent((ConfluenceEntityObject)contentEntityObject);
        context.putAll(MacroUtils.defaultVelocityContext());
        DataSource avatarDataSource = this.imageDataSourceFactory.getAvatar(user);
        context.put("avatarCid", (Object)avatarDataSource.getName());
        context.addTemplateImage(this.imageDataSourceFactory.getAvatar(user));
        context.put("sender", (Object)user);
        context.put("ceo", (Object)contentEntityObject);
        ContentEntityObject tinyUrlTarget = contentEntityObject;
        if ("comment".equals(contentEntityObject.getType())) {
            Comment comment = (Comment)contentEntityObject;
            tinyUrlTarget = comment.getContainer();
            context.put("comment", (Object)contentEntityObject);
        } else if ("page".equals(contentEntityObject.getType())) {
            context.put("page", (Object)contentEntityObject);
        } else if ("blogpost".equals(contentEntityObject.getType())) {
            context.put("page", (Object)contentEntityObject);
        }
        String domainName = this.globalSettingsManager.getGlobalSettings().getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        context.put("baseurl", (Object)domainName);
        if (tinyUrlTarget != null) {
            context.put("tinyUrl", (Object)(domainName + "/x/" + new TinyUrl(tinyUrlTarget.getId()).getIdentifier()));
        }
        return notificationData;
    }
}

