/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.content.datasource.ResourceModuleDescriptor;
import com.atlassian.confluence.content.render.xhtml.storage.InlineTasksUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.mentions.NotificationEmailFactory;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.user.User;
import java.util.function.Predicate;

public class NotificationEmailFactoryImpl
implements NotificationEmailFactory {
    private final DataSourceFactory imageDataSourceFactory;

    public NotificationEmailFactoryImpl(DataSourceFactory imageDataSourceFactory) {
        this.imageDataSourceFactory = imageDataSourceFactory;
    }

    @Override
    public PreRenderedMailNotificationQueueItem create(ContentEntityObject contentEntityObject, ConfluenceUser recipient, ConfluenceUser sender, String templateLocation, String templateName, String subject, NotificationContext context) {
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with((User)recipient, (String)templateName, (String)subject).andSender((User)sender).andTemplateLocation(templateLocation).andContext(context.getMap());
        ModuleCompleteKey moduleKey = new ModuleCompleteKey("com.atlassian.confluence.plugins.confluence-mentions-plugin", "mention-icon");
        this.imageDataSourceFactory.getResourceFromModuleByName(moduleKey, "mention-icon").ifPresent(arg_0 -> ((NotificationContext)context).addTemplateImage(arg_0));
        String mentionExcerpt = (String)context.get("contentHtml");
        for (DataSource resource : InlineTasksUtils.getRequiredResources((DataSourceFactory)this.imageDataSourceFactory, (String)mentionExcerpt)) {
            context.addTemplateImage(resource);
        }
        builder.andRelatedBodyParts((Iterable)context.getTemplateImageDataSources()).andRelatedBodyParts(this.imagesUsedByChromeTemplate());
        return builder.render();
    }

    private Iterable<DataSource> imagesUsedByChromeTemplate() {
        ModuleCompleteKey moduleKey = new ModuleCompleteKey("com.atlassian.confluence.plugins.confluence-email-resources", "chrome-template");
        return this.imageDataSourceFactory.getResourcesFromModules(moduleKey, (Predicate)ResourceModuleDescriptor.Filters.IMAGE);
    }
}

