/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mentions.notifications;

import com.atlassian.confluence.plugins.mentions.notifications.MentionContentPayload;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SimpleMentionContentPayload
implements MentionContentPayload {
    @JsonProperty
    private long contentId;
    @JsonProperty
    private ContentTypeEnum contentType;
    @JsonProperty
    private String mentionedUserKey;
    @JsonProperty
    private String mentionedHtml;
    @JsonProperty
    private String originatingUserKey;
    @JsonProperty
    private UserKey authorUserKey;

    public SimpleMentionContentPayload() {
    }

    @Deprecated
    public SimpleMentionContentPayload(long contentId, ContentTypeEnum contentType, UserKey originatingUserKey, String mentionedUserKey, String mentionedHtml) {
        this.contentId = contentId;
        this.contentType = contentType;
        this.mentionedUserKey = mentionedUserKey;
        this.mentionedHtml = mentionedHtml;
        this.originatingUserKey = originatingUserKey.getStringValue();
    }

    public SimpleMentionContentPayload(long contentId, ContentTypeEnum contentType, UserKey originatingUserKey, UserKey mentionedUserKey, String mentionedHtml) {
        this.contentId = contentId;
        this.contentType = contentType;
        this.mentionedUserKey = mentionedUserKey != null ? mentionedUserKey.getStringValue() : null;
        this.mentionedHtml = mentionedHtml;
        this.originatingUserKey = originatingUserKey != null ? originatingUserKey.getStringValue() : null;
        this.authorUserKey = originatingUserKey;
    }

    @Override
    public long getContentId() {
        return this.contentId;
    }

    @Override
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @Override
    public UserKey getMentionedUserKey() {
        return new UserKey(this.mentionedUserKey);
    }

    @Override
    public Optional<String> getMentionHtml() {
        if (StringUtils.isBlank((CharSequence)this.mentionedHtml)) {
            return Optional.empty();
        }
        return Optional.of(this.mentionedHtml);
    }

    @Override
    public Optional<UserKey> getAuthorUserKey() {
        return Optional.ofNullable(this.authorUserKey);
    }

    public Optional<UserKey> getOriginatorUserKey() {
        return StringUtils.isEmpty((CharSequence)this.originatingUserKey) ? Optional.empty() : Optional.of(new UserKey(this.originatingUserKey));
    }
}

