/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.soy;

import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.model.WebPanel;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorWebPanelFunction
implements SoyServerFunction<List<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(EditorWebPanelFunction.class);
    private final DynamicWebInterfaceManager webInterfaceManager;

    public EditorWebPanelFunction(DynamicWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public String getName() {
        return "getEditorWebPanels";
    }

    public List<String> apply(Object ... args) {
        String location = (String)args[0];
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        if (args.length == 2) {
            contextBuilder.putAll(Maps.filterValues((Map)((Map)args[1]), (Predicate)Predicates.notNull()));
        }
        ImmutableMap context = contextBuilder.build();
        ArrayList<String> webPanels = new ArrayList<String>();
        for (WebPanel webPanel : this.webInterfaceManager.getDisplayableWebPanels(location, (Map)context)) {
            try {
                webPanels.add(webPanel.getHtml((Map)context));
            }
            catch (RuntimeException e) {
                LOG.warn("An error occurred rendering {}. ", (Object)location, (Object)e);
            }
        }
        return webPanels;
    }

    public Set<Integer> validArgSizes() {
        return Set.of(Integer.valueOf(1), Integer.valueOf(2));
    }
}

