/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.soy;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.core.InputStreamSerializer;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;

public class ImportResourceFunction
implements SoyServerFunction<String> {
    private static final ImmutableSet<Integer> VALID_ARGUMENT_SIZES = ImmutableSet.of((Object)2);
    private final DataSourceFactory dataSourceFactory;

    public ImportResourceFunction(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public String getName() {
        return "importResource";
    }

    public String apply(Object ... args) {
        ModuleCompleteKey moduleCompleteKey = new ModuleCompleteKey((String)args[0]);
        String resourceName = (String)args[1];
        Optional maybeResource = this.dataSourceFactory.getResourceFromModuleByName(moduleCompleteKey, resourceName);
        if (!maybeResource.isPresent() && !ConfluenceSystemProperties.isDevMode()) {
            return "";
        }
        Callable[] callableArray = new Callable[1];
        callableArray[0] = () -> ((DataSource)((DataSource)maybeResource.get())).getInputStream();
        return InputStreamSerializer.eagerInDevMode().add(callableArray).toString();
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARGUMENT_SIZES;
    }
}

