/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.soy;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.web.WebViewService;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ItemsForSectionFunction
implements SoyServerFunction<Iterable<WebItemView>> {
    private final WebViewService webViewService;

    public ItemsForSectionFunction(WebViewService webViewService) {
        this.webViewService = webViewService;
    }

    public String getName() {
        return "itemsForSection";
    }

    public Iterable<WebItemView> apply(Object ... args) {
        Optional<ContentId> contentId = this.computeContentId(args[0]);
        String section = (String)args[1];
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        if (args.length == 3) {
            contextBuilder.putAll((Map)args[2]);
        }
        ImmutableMap additionalContext = contextBuilder.build();
        return this.webViewService.forContent((ContentId)contentId.orElse(null), (Map)additionalContext).getItemsForSection(section, (Map)additionalContext);
    }

    private Optional<ContentId> computeContentId(Object arg) {
        ContentId contentIdObject;
        if (arg == null) {
            return Optional.empty();
        }
        if (arg instanceof String) {
            String contentId = (String)arg;
            try {
                contentIdObject = ContentId.deserialise((String)contentId);
            }
            catch (BadRequestException e) {
                throw new RuntimeException("Error deserializing contentId [" + contentId + "]", e);
            }
        } else if (arg instanceof ContentId) {
            ContentId contentId;
            contentIdObject = contentId = (ContentId)arg;
        } else {
            throw new IllegalArgumentException("argument 0 to soy function '" + this.getName() + "' must be of type String, or [" + ContentId.class.getName() + "]. Got [" + arg.getClass().getName() + "]");
        }
        return Optional.of(contentIdObject);
    }

    public Set<Integer> validArgSizes() {
        return Set.of(Integer.valueOf(2), Integer.valueOf(3));
    }
}

