/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import java.util.Objects;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextMapperCallbackHandler;
import org.springframework.ldap.core.ObjectRetrievalException;

public class AttributeToContextCallbackHandler<T>
extends ContextMapperCallbackHandler<T> {
    private final ContextMapper<T> mapper;

    public AttributeToContextCallbackHandler(ContextMapper<T> mapper) {
        super(mapper);
        Objects.requireNonNull(mapper, "Mapper must not be empty");
        this.mapper = mapper;
    }

    public T getObjectFromNameClassPair(NameClassPair nameClassPair) throws NamingException {
        if (!(nameClassPair instanceof Binding)) {
            throw new IllegalArgumentException("Parameter must be an instance of Binding");
        }
        Binding binding = (Binding)nameClassPair;
        Object object = binding.getObject();
        if (object == null) {
            if (!(nameClassPair instanceof SearchResult)) {
                throw new ObjectRetrievalException("Binding did not contain any object.");
            }
            object = new NameAttributesPair(DNStandardiser.standardiseToName(nameClassPair.getNameInNamespace(), false), ((SearchResult)nameClassPair).getAttributes());
        }
        return (T)this.mapper.mapFromContext(object);
    }
}

