/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.name;

import com.atlassian.crowd.directory.ldap.name.Converter;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapNameFactory;
import com.atlassian.crowd.directory.ldap.name.LdapNameFormatException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.Rdn;

public class GenericConverter
implements Converter {
    private final CrowdLdapNameFactory ldapNameFactory = CrowdLdapNameFactory.getInstance();

    @Override
    public CrowdLdapName getName(String dn) throws LdapNameFormatException {
        return this.ldapNameFactory.get(dn);
    }

    @Override
    public CrowdLdapName getName(String attributeName, String objectName, CrowdLdapName baseDn) throws LdapNameFormatException {
        List<Object> baseRdnList = baseDn == null ? Collections.emptyList() : baseDn.getRdns();
        ArrayList<Rdn> rdnList = new ArrayList<Rdn>(baseRdnList);
        try {
            rdnList.add(new Rdn(attributeName, objectName));
        }
        catch (InvalidNameException e) {
            throw new LdapNameFormatException(e);
        }
        return this.ldapNameFactory.get(rdnList);
    }
}

