/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.name;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapNameFactory;
import com.atlassian.crowd.directory.ldap.name.LdapNameFormatException;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDN {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CrowdLdapNameFactory ldapNameFactory = CrowdLdapNameFactory.getInstance();
    private final LDAPPropertiesMapper propertiesMapper;

    public SearchDN(LDAPPropertiesMapper propertiesMapper) {
        this.propertiesMapper = propertiesMapper;
    }

    public CrowdLdapName getGroup() {
        try {
            return this.getSearchDN("ldap.group.dn");
        }
        catch (LdapNameFormatException e) {
            this.logger.error("Group Search DN could not be parsed", (Throwable)e);
            return this.ldapNameFactory.getEmptyLdapName();
        }
    }

    public CrowdLdapName getUser() {
        try {
            return this.getSearchDN("ldap.user.dn");
        }
        catch (LdapNameFormatException e) {
            this.logger.error("User Search DN could not be parsed", (Throwable)e);
            return this.ldapNameFactory.getEmptyLdapName();
        }
    }

    public CrowdLdapName getBase() throws LdapNameFormatException {
        return this.standardiseDn(this.propertiesMapper.getAttribute("ldap.basedn"));
    }

    public CrowdLdapName getNamingContext() {
        CrowdLdapName baseDN;
        try {
            baseDN = this.getBase();
        }
        catch (LdapNameFormatException e) {
            baseDN = this.ldapNameFactory.getEmptyLdapName();
        }
        return baseDN;
    }

    protected CrowdLdapName getSearchDN(String propertyName) throws LdapNameFormatException {
        String additionalDn = this.propertiesMapper.getAttribute(propertyName);
        String baseDn = this.propertiesMapper.getAttribute("ldap.basedn");
        Object searchDn = StringUtils.isNotBlank((CharSequence)baseDn) ? (StringUtils.isNotBlank((CharSequence)additionalDn) ? additionalDn + "," + baseDn : baseDn) : (StringUtils.isNotBlank((CharSequence)additionalDn) ? additionalDn : "");
        return this.standardiseDn((String)searchDn);
    }

    final CrowdLdapName standardiseDn(String dn) {
        return DNStandardiser.standardiseToName(dn, !this.propertiesMapper.isRelaxedDnStandardisation());
    }
}

