/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.baseurl;

import com.atlassian.confluence.plugin.webresource.ConfluenceWebResourceManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class IncludeResourcesFilter
extends HttpFilter {
    static final String BASE_URL_RESOURCE_CONTEXT = "baseurl-checker-resource";
    private static final Set<String> UNFILTERED_REQUEST_URLS = Set.of("/plugins/servlet/mobile");
    private final ConfluenceWebResourceManager webResourceManager;
    private final PermissionManager permissionManager;

    @Autowired
    public IncludeResourcesFilter(@ComponentImport ConfluenceWebResourceManager webResourceManager, @ComponentImport PermissionManager permissionManager) {
        this.webResourceManager = webResourceManager;
        this.permissionManager = permissionManager;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.permissionManager.isSystemAdministrator(AuthenticatedUserThreadLocal.get()) && this.isURIFilterable(request.getRequestURI().substring(request.getContextPath().length()))) {
            this.webResourceManager.requireResourcesForContext(BASE_URL_RESOURCE_CONTEXT);
            this.webResourceManager.putMetadata("server-scheme", String.valueOf(request.getScheme()));
            this.webResourceManager.putMetadata("server-port", String.valueOf(request.getServerPort()));
            this.webResourceManager.putMetadata("server-name", String.valueOf(request.getServerName()));
            this.webResourceManager.putMetadata("behind-proxy", String.valueOf(request.getHeader("Http-X-Forwarded-For")));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isURIFilterable(String requestURI) {
        return UNFILTERED_REQUEST_URLS.stream().noneMatch(requestURI::startsWith);
    }
}

