/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;

public class OsgiUtils {
    public static Optional<Object> findApplicationContextInOsgiBundle(Plugin plugin) {
        if (!(plugin instanceof OsgiPlugin)) {
            return Optional.empty();
        }
        OsgiPlugin osgiPlugin = (OsgiPlugin)plugin;
        String referencingBundleName = osgiPlugin.getBundle().getSymbolicName();
        BundleContext bundleContext = osgiPlugin.getBundle().getBundleContext();
        try {
            String filterString = "(&(objectClass=" + ApplicationContext.class.getName() + ")(Bundle-SymbolicName=" + referencingBundleName + "))";
            Filter filter = bundleContext.createFilter(filterString);
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(ApplicationContext.class.getName(), filter.toString());
            if (serviceReferences == null || serviceReferences.length == 0) {
                return Optional.empty();
            }
            return Optional.of(bundleContext.getService(serviceReferences[0]));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unexpected issue with OSGi filter expression", e);
        }
    }
}

