/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.crypto.ClusterAwareCipherWrapper;
import com.atlassian.crowd.crypto.EncryptionKeyFilePermissionChanger;
import com.atlassian.crowd.crypto.FileChecker;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.exception.crypto.MissingKeyException;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.secrets.api.SecretStore;
import com.atlassian.secrets.api.SecretStoreProvider;
import com.atlassian.secrets.store.algorithm.paramters.DecryptionParameters;
import com.atlassian.secrets.store.algorithm.paramters.EncryptionParameters;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConfigPasswordCipherEncryptor
implements Encryptor {
    private static final Logger log = LoggerFactory.getLogger(DbConfigPasswordCipherEncryptor.class);
    private static final String CIPHER_PROVIDER_CLASS_NAME = "com.atlassian.secrets.store.algorithm.AlgorithmSecretStore";
    private final String algorithm;
    private final String algorithmKey;
    private final EncryptionSettings encryptionSettings;
    private final ClusterAwareCipherWrapper cipher;

    @VisibleForTesting
    DbConfigPasswordCipherEncryptor(String algorithm, String algorithmKey, EncryptionSettings encryptionSettings, ClusterAwareCipherWrapper cipher) {
        this.algorithm = algorithm;
        this.algorithmKey = algorithmKey;
        this.encryptionSettings = encryptionSettings;
        this.cipher = cipher;
    }

    public DbConfigPasswordCipherEncryptor(String algorithm, String algorithmKey, EncryptionSettings encryptionSettings, SecretStoreProvider cipherProvider) {
        this(algorithm, algorithmKey, encryptionSettings, DbConfigPasswordCipherEncryptor.getCipher(cipherProvider, encryptionSettings));
    }

    private static ClusterAwareCipherWrapper getCipher(SecretStoreProvider cipherProvider, EncryptionSettings encryptionSettings) {
        SecretStore cipher = (SecretStore)cipherProvider.getInstance(CIPHER_PROVIDER_CLASS_NAME).orElseThrow(() -> new IllegalStateException(String.format("Cipher %s not found", CIPHER_PROVIDER_CLASS_NAME)));
        return new ClusterAwareCipherWrapper(encryptionSettings, cipher, new FileChecker(), new EncryptionKeyFilePermissionChanger());
    }

    public String encrypt(String password) {
        Optional encryptorDefaultKeyPath = this.encryptionSettings.getEncryptionKeyPath(this.algorithmKey);
        if (!encryptorDefaultKeyPath.isPresent()) {
            log.warn("Default encryption key is not present. Encryptor was not initialized properly.");
            throw new MissingKeyException();
        }
        DecryptionParameters decryptionParameters = this.doEncrypt(password, encryptorDefaultKeyPath.orElse(null));
        Gson gson = new Gson();
        return gson.toJson((Object)decryptionParameters);
    }

    public String decrypt(String encryptedPassword) {
        Gson gson = new Gson();
        DecryptionParameters decryptionParameters = (DecryptionParameters)gson.fromJson(encryptedPassword, DecryptionParameters.class);
        try {
            return this.cipher.decrypt(decryptionParameters);
        }
        catch (RuntimeException e) {
            log.error("Error during decryption", (Throwable)e);
            return encryptedPassword;
        }
    }

    public boolean changeEncryptionKey() {
        DecryptionParameters decryptionParameters = this.doEncrypt("", null);
        this.encryptionSettings.setEncryptionKeyPath(this.algorithmKey, decryptionParameters.getKeyFilePath());
        return true;
    }

    private DecryptionParameters doEncrypt(String password, String encryptionKeyPath) {
        EncryptionParameters encryptionParameters = new EncryptionParameters.Builder().setAlgorithm(this.algorithm).setAlgorithmKey(this.algorithmKey).setKeyFilePath(encryptionKeyPath).setOutputFilesBasePath(this.encryptionSettings.getKeyFilesDirectoryPath() + File.separator).setSaveAlgorithmParametersToSeparateFile(Boolean.valueOf(false)).setSaveSealedObjectToSeparateFile(Boolean.valueOf(false)).setPlainTextPassword(password).build();
        return this.cipher.encrypt(encryptionParameters);
    }
}

