/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ui.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.legacyapi.service.content.SpaceLabelService;
import com.atlassian.confluence.ui.rest.content.LegacyRestHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;

@Deprecated
@Path(value="/space")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LegacySpaceResource {
    private final SpaceLabelService spaceLabelService;

    @Inject
    public LegacySpaceResource(SpaceLabelService spaceLabelService) {
        this.spaceLabelService = spaceLabelService;
    }

    @DELETE
    @Path(value="/{key}/label/{labelId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteLabel(@PathParam(value="key") String spaceKey, @PathParam(value="labelId") Long labelId) {
        try {
            this.spaceLabelService.removeLabel(spaceKey, labelId.longValue());
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (IllegalArgumentException e) {
            Map<String, Object> result = LegacyRestHelper.createFailureResultMap(e);
            return Response.ok(result).status(Response.Status.FORBIDDEN).build();
        }
    }
}

