/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ui.rest.service.content;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.labels.service.AddLabelsCommand;
import com.atlassian.confluence.labels.service.LabelsService;
import com.atlassian.confluence.labels.service.RemoveLabelCommand;
import com.atlassian.confluence.legacyapi.NotFoundException;
import com.atlassian.confluence.legacyapi.model.content.Label;
import com.atlassian.confluence.legacyapi.service.content.AttachmentService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.ui.rest.service.content.LegacyLabelHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component(value="localAttachmentService")
public class LegacyAttachmentServiceImpl
implements AttachmentService {
    private static final String ATTACHMENT_ENTITY_TYPE = "attachment";
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final LabelsService labelsService;
    private final LegacyLabelHelper labelHelper;

    @Autowired
    public LegacyAttachmentServiceImpl(@ComponentImport AttachmentManager attachmentManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LabelsService labelsService, @ComponentImport I18NBeanFactory i18NBeanFactory) {
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.labelsService = labelsService;
        this.labelHelper = new LegacyLabelHelper(i18NBeanFactory);
    }

    public Iterable<Label> getLabels(long attachmentId, Collection<Label.Prefix> prefixes) {
        return this.labelHelper.extractViewableLabels(this.getAttachmentIfViewable(attachmentId), prefixes, (User)AuthenticatedUserThreadLocal.get());
    }

    private AbstractLabelableEntityObject getAttachmentIfViewable(long attachmentId) {
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null || !this.canView(attachment)) {
            throw new NotFoundException("Attachment with id " + attachmentId + " is either missing or not visible to this user");
        }
        return attachment;
    }

    private boolean canView(Attachment attachment) {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment);
    }

    public Iterable<Label> addLabels(long attachmentId, Iterable<Label> labels) {
        String labelsString = this.labelHelper.concatentateLabels(labels);
        AddLabelsCommand command = this.labelsService.newAddLabelCommand(labelsString, AuthenticatedUserThreadLocal.get(), attachmentId, ATTACHMENT_ENTITY_TYPE);
        this.labelHelper.validateLabelsCommand((ServiceCommand)command);
        command.execute();
        return this.getLabels(attachmentId, Arrays.asList(Label.Prefix.values()));
    }

    public void removeLabel(long attachmentId, long labelId) {
        RemoveLabelCommand command = this.labelsService.newRemoveLabelCommand(labelId, AuthenticatedUserThreadLocal.get(), attachmentId);
        this.labelHelper.validateLabelsCommand((ServiceCommand)command);
        command.execute();
    }
}

