/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.lifecycle;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.confluence.setup.SetupCompleteEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.sal.core.lifecycle.DefaultLifecycleManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceLifecycleManager
extends DefaultLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceLifecycleManager.class);
    private final AtlassianBootstrapManager bootstrapManager;
    private final EventListenerRegistrar eventListenerRegistrar;

    public ConfluenceLifecycleManager(PluginEventManager pluginEventManager, PluginAccessor pluginAccessor, BundleContext bundleContext, AtlassianBootstrapManager bootstrapManager, EventListenerRegistrar eventListenerRegistrar) {
        super(pluginEventManager, pluginAccessor, bundleContext);
        this.bootstrapManager = bootstrapManager;
        this.eventListenerRegistrar = eventListenerRegistrar;
    }

    @PostConstruct
    void init() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    void dispose() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onSetupComplete(SetupCompleteEvent event) {
        log.info("Invoking lifecycle startup callbacks for all plugins");
        this.start();
    }

    protected void notifyOnStart() {
        log.info("Plugin lifecycle startup callbacks completed");
    }

    public boolean isApplicationSetUp() {
        return this.bootstrapManager.isSetupComplete();
    }
}

