/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.lifecycle;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ZduManager;
import com.atlassian.confluence.cluster.ZduStatus;
import com.atlassian.confluence.event.events.cluster.ZduFinalizationRequestEvent;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.core.upgrade.DefaultPluginUpgradeManager;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginUpgradeFinalizationManager
extends DefaultPluginUpgradeManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPluginUpgradeFinalizationManager.class);
    private final ZduManager zduManager;

    public DefaultPluginUpgradeFinalizationManager(List<PluginUpgradeTask> upgradeTasks, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory, PluginEventManager pluginEventManager, ClusterLockService clusterLockService, ZduManager zduManager) {
        super(upgradeTasks, transactionTemplate, pluginAccessor, pluginSettingsFactory, pluginEventManager, clusterLockService, ":build:finalized");
        this.zduManager = zduManager;
    }

    public List<Message> upgradeInternal() {
        if (this.shouldRunUpgradeTasks()) {
            return super.upgradeInternal();
        }
        logger.info("ZDU mode enabled: omit finalization tasks");
        return Collections.emptyList();
    }

    public List<Message> upgradeInternal(Plugin plugin) {
        if (this.shouldRunUpgradeTasks()) {
            return super.upgradeInternal(plugin);
        }
        logger.info("ZDU mode enabled: omit finalization tasks");
        return Collections.emptyList();
    }

    private boolean shouldRunUpgradeTasks() {
        return this.zduManager.getUpgradeStatus().getState() == ZduStatus.State.DISABLED;
    }

    @PluginEventListener
    public void onFinalizationRequested(ZduFinalizationRequestEvent event) {
        for (Message msg : this.upgradeInternal()) {
            logger.error("ZDU finalization error: {}", (Object)msg);
        }
    }
}

