/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.oauth.seraph;

import com.atlassian.confluence.dmz.sal.AuthenticationListenerExt;
import com.atlassian.confluence.event.events.security.LoginDetails;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.LoginDetailsHelper;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.core.auth.SeraphAuthenticationListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSeraphAuthenticationListener
extends SeraphAuthenticationListener
implements AuthenticationListenerExt {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSeraphAuthenticationListener.class);
    private final EventPublisher eventPublisher;
    private final LoginManager loginManager;
    private final HttpContext httpContext;

    public ConfluenceSeraphAuthenticationListener(EventPublisher eventPublisher, LoginManager loginManager, HttpContext httpContext) {
        this.eventPublisher = eventPublisher;
        this.loginManager = loginManager;
        this.httpContext = httpContext;
    }

    public void authenticationSuccess(Authenticator.Result result, HttpServletRequest request, HttpServletResponse response) {
        ConfluenceUserPrincipal principal = ConfluenceUserPrincipal.of((Principal)result.getPrincipal());
        super.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(new Message(){

            public String getKey() {
                return "Successful authentication and conversion to ConfluenceUserPrincipal";
            }

            public Serializable[] getArguments() {
                return null;
            }
        }, (Principal)principal), request, response);
        if (log.isDebugEnabled()) {
            String sessionId = request.getSession(false) == null ? null : request.getSession(false).getId();
            log.debug("Successfully authenticated user {} and set `seraph_defaultauthenticator_user` attribute in session {} for request {}", new Object[]{principal, sessionId, request.getPathInfo()});
        }
        this.postLogin(request, principal);
    }

    private void postLogin(HttpServletRequest request, ConfluenceUserPrincipal principal) {
        if (LoginDetailsHelper.isSsoLogin((HttpServletRequest)request)) {
            this.postLogin(request, principal, LoginDetails.LoginSource.SSO);
        } else if (LoginDetailsHelper.isTwosvCompatibleLogin((HttpServletRequest)request)) {
            this.postLogin(request, principal, LoginDetails.LoginSource.TSV_FORM);
        }
    }

    private void postLogin(HttpServletRequest request, ConfluenceUserPrincipal principal, LoginDetails.LoginSource loginSource) {
        if (principal != null) {
            this.loginManager.onSuccessfulLoginAttempt(principal.getName(), request);
            LoginDetails loginDetails = new LoginDetails(loginSource, null);
            this.eventPublisher.publish((Object)new LoginEvent((Object)this, principal.getName(), request.getSession().getId(), request.getRemoteHost(), request.getRemoteAddr(), loginDetails));
        }
    }

    public void authenticationSuccess(Authenticator.Result result) {
        this.authenticationSuccess(result, this.httpContext.getActiveRequest(), this.httpContext.getActiveResponse());
    }

    public void authenticationFailure(Authenticator.Result result) {
        this.authenticationFailure(result, this.httpContext.getActiveRequest(), this.httpContext.getActiveResponse());
    }

    public void authenticationError(Authenticator.Result result) {
        this.authenticationError(result, this.httpContext.getActiveRequest(), this.httpContext.getActiveResponse());
    }

    public void authenticationNotAttempted() {
        this.authenticationNotAttempted(this.httpContext.getActiveRequest(), this.httpContext.getActiveResponse());
    }
}

