/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.websudo;

import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;

public class ConfluenceWebSudoManager
implements WebSudoManager {
    private final com.atlassian.confluence.security.websudo.WebSudoManager delegate;

    public ConfluenceWebSudoManager(com.atlassian.confluence.security.websudo.WebSudoManager delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public boolean canExecuteRequest(HttpServletRequest httpServletRequest) {
        return this.delegate.canExecuteRequest(httpServletRequest);
    }

    public void enforceWebSudoProtection(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.delegate.enforceWebSudoProtection(request, response);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to redirect to /authenticate.action");
        }
    }

    public void willExecuteWebSudoRequest(HttpServletRequest httpServletRequest) throws WebSudoSessionException {
        if (!this.canExecuteRequest(httpServletRequest)) {
            throw new WebSudoSessionException("Invalid request: Not in a WebSudo session");
        }
        this.delegate.markWebSudoRequest(httpServletRequest);
    }
}

