/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.api;

public enum CspDirective {
    DEFAULT_SRC("default-src"),
    SCRIPT_SRC("script-src"),
    STYLE_SRC("style-src"),
    IMG_SRC("img-src"),
    CONNECT_SRC("connect-src"),
    FONT_SRC("font-src"),
    OBJECT_SRC("object-src"),
    MEDIA_SRC("media-src"),
    FRAME_SRC("frame-src"),
    SANDBOX("sandbox"),
    REPORT_TO("report-to"),
    REPORT_URI("report-uri"),
    CHILD_SRC("child-src"),
    FORM_ACTION("form-action"),
    FRAME_ANCESTORS("frame-ancestors"),
    PLUGIN_TYPES("plugin-types"),
    BASE_URI("base-uri");

    private final String directive;

    private CspDirective(String directive) {
        this.directive = directive;
    }

    public String getDirective() {
        return this.directive;
    }

    public static CspDirective fromString(String directive) {
        for (CspDirective d : CspDirective.values()) {
            if (!d.directive.equalsIgnoreCase(directive)) continue;
            return d;
        }
        throw new IllegalArgumentException("Unknown directive: " + directive);
    }
}

