/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugins.createcontent.AoBackedManager;
import com.atlassian.confluence.plugins.createcontent.BlueprintConstants;
import com.atlassian.confluence.plugins.createcontent.activeobjects.PluginBackedBlueprintAo;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContextKeys;
import com.atlassian.confluence.plugins.createcontent.impl.PluginBackedBlueprint;
import com.atlassian.confluence.plugins.createcontent.model.BlueprintState;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPluginSettingsBlueprintStateController {
    private final PluginSettingsFactory pluginSettingsFactory;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final PluginAccessor pluginAccessor;
    private final PluginSettings globalPluginSettings;
    private static final Function<String, UUID> getUuidFromString = UUID::fromString;
    private static final Predicate<UUID> isUuidNull = Objects::nonNull;
    private static final Function<UUID, String> getStringFromUuid = UUID::toString;

    protected AbstractPluginSettingsBlueprintStateController(PluginSettingsFactory pluginSettingsFactory, DynamicWebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.webInterfaceManager = webInterfaceManager;
        this.pluginAccessor = pluginAccessor;
    }

    protected void enableBlueprint(UUID blueprintId, Space space, String pluginSettingsKey) {
        if (blueprintId == null) {
            throw new IllegalArgumentException("Blueprint UUID is required.");
        }
        PluginSettings pluginSettings = space == null ? this.globalPluginSettings : this.pluginSettingsFactory.createSettingsForKey(AbstractPluginSettingsBlueprintStateController.getModuleNamespace(space));
        Set disabledBlueprintsIds = (Set)pluginSettings.get(pluginSettingsKey);
        if (disabledBlueprintsIds != null) {
            disabledBlueprintsIds.remove(blueprintId.toString());
            pluginSettings.put(pluginSettingsKey, (Object)disabledBlueprintsIds);
        }
    }

    public static String getModuleNamespace(Space space) {
        return "com.atlassian.confluence.blueprints.plugin-module-state:" + space.getKey();
    }

    protected void disableBlueprint(UUID blueprintId, Space space, String pluginSettingsKey) {
        if (blueprintId == null) {
            throw new IllegalArgumentException("blueprint UUID is required.");
        }
        if (blueprintId.equals(BlueprintConstants.BLANK_PAGE_BLUEPRINT.getId()) || blueprintId.equals(BlueprintConstants.BLOG_POST_BLUEPRINT.getId())) {
            throw new IllegalArgumentException("You cannot disable this blueprint.");
        }
        PluginSettings pluginSettings = space == null ? this.globalPluginSettings : this.pluginSettingsFactory.createSettingsForKey(AbstractPluginSettingsBlueprintStateController.getModuleNamespace(space));
        HashSet<String> disabledBlueprintsIds = (HashSet<String>)pluginSettings.get(pluginSettingsKey);
        if (disabledBlueprintsIds == null) {
            disabledBlueprintsIds = new HashSet<String>();
        }
        disabledBlueprintsIds.add(blueprintId.toString());
        pluginSettings.put(pluginSettingsKey, disabledBlueprintsIds);
    }

    protected void disableBlueprints(Set<UUID> blueprintIds, Space space, String pluginSettingsKey) {
        if (blueprintIds == null || blueprintIds.isEmpty()) {
            return;
        }
        PluginSettings pluginSettings = space == null ? this.globalPluginSettings : this.pluginSettingsFactory.createSettingsForKey(AbstractPluginSettingsBlueprintStateController.getModuleNamespace(space));
        HashSet<String> disabledBlueprintsIds = (HashSet<String>)pluginSettings.get(pluginSettingsKey);
        if (disabledBlueprintsIds == null) {
            disabledBlueprintsIds = new HashSet<String>();
        }
        List<String> disableBlueprintIds = blueprintIds.stream().map(getStringFromUuid).toList();
        disabledBlueprintsIds.addAll(disableBlueprintIds);
        pluginSettings.put(pluginSettingsKey, disabledBlueprintsIds);
    }

    protected Set<UUID> getDisabledBlueprintIds(Space space, String pluginSettingsKey) {
        HashSet<UUID> disabledBlueprintIds = new HashSet<UUID>();
        disabledBlueprintIds.addAll(this.getDisabledPluginIds(this.pluginSettingsFactory.createGlobalSettings(), pluginSettingsKey));
        if (space != null) {
            disabledBlueprintIds.addAll(this.getDisabledPluginIds(this.pluginSettingsFactory.createSettingsForKey(AbstractPluginSettingsBlueprintStateController.getModuleNamespace(space)), pluginSettingsKey));
        }
        return disabledBlueprintIds;
    }

    protected Set<UUID> getDisabledPluginIds(PluginSettings pluginSettings, String pluginSettingsKey) {
        Set disabledBlueprints = (Set)pluginSettings.get(pluginSettingsKey);
        if (disabledBlueprints == null || disabledBlueprints.isEmpty()) {
            return new HashSet<UUID>();
        }
        List<UUID> disableBlueprintIds = disabledBlueprints.stream().map(getUuidFromString).filter(Objects::nonNull).toList();
        return new HashSet<UUID>(disableBlueprintIds);
    }

    protected Set<String> getDisabledSpaceBlueprintModuleCompleteKeys(Space space, String pluginSettingsKey, AoBackedManager<? extends PluginBackedBlueprint, ? extends PluginBackedBlueprintAo> blueprintManager) {
        Set<UUID> disabledModuleIds = this.getDisabledBlueprintIds(space, pluginSettingsKey);
        List<String> globalDisabledModuleCompleteKeys = disabledModuleIds.stream().map(blueprintId -> {
            PluginBackedBlueprint blueprint = (PluginBackedBlueprint)blueprintManager.getById((UUID)blueprintId);
            if (blueprint != null) {
                return blueprint.getModuleCompleteKey();
            }
            return null;
        }).filter(input -> input != null && !input.isEmpty()).toList();
        return new HashSet<String>(globalDisabledModuleCompleteKeys);
    }

    protected Map<UUID, BlueprintState> buildBlueprintStateMap(String section, ConfluenceUser user, Space space, String pluginSettingsKey, Collection<? extends PluginBackedBlueprint> blueprints) {
        HashMap<UUID, BlueprintState> blueprintStateMap = new HashMap<UUID, BlueprintState>();
        Set<UUID> globallyDisabledBlueprintIds = this.getDisabledBlueprintIds(null, pluginSettingsKey);
        Set spaceDisabledBlueprintIds = space == null ? Collections.emptySet() : this.getDisabledBlueprintIds(space, pluginSettingsKey);
        Collection<String> webInterfaceManagerDisplayableModules = this.getWebInterfaceManagerDisplayableBlueprintModuleKeys(section, user, space);
        for (PluginBackedBlueprint pluginBackedBlueprint : blueprints) {
            String moduleCompleteKey = pluginBackedBlueprint.getModuleCompleteKey();
            UUID blueprintId = pluginBackedBlueprint.getId();
            boolean isPluginBacked = StringUtils.isNotBlank((CharSequence)moduleCompleteKey);
            BlueprintState blueprintState = new BlueprintState.Builder().disabledInPluginSystem(isPluginBacked && !this.pluginAccessor.isPluginModuleEnabled(moduleCompleteKey)).disabledGlobally(globallyDisabledBlueprintIds.contains(blueprintId)).disabledInSpace(spaceDisabledBlueprintIds.contains(blueprintId)).disabledByWebInterfaceManager(isPluginBacked && !webInterfaceManagerDisplayableModules.contains(moduleCompleteKey)).build();
            blueprintStateMap.put(blueprintId, blueprintState);
        }
        return blueprintStateMap;
    }

    private Collection<String> getWebInterfaceManagerDisplayableBlueprintModuleKeys(String section, ConfluenceUser user, Space space) {
        DefaultWebInterfaceContext webInterfaceContext = new DefaultWebInterfaceContext();
        webInterfaceContext.setSpace(space);
        webInterfaceContext.setCurrentUser(user);
        Map webInterfaceContextMap = webInterfaceContext.toMap();
        HashSet<String> displayableBlueprintKeys = new HashSet<String>();
        for (WebItemModuleDescriptor webItemModuleDescriptor : this.webInterfaceManager.getDisplayableItems(section, webInterfaceContextMap)) {
            String blueprintKey = (String)webItemModuleDescriptor.getParams().get(BlueprintContextKeys.BLUEPRINT_MODULE_KEY.key());
            if (StringUtils.isBlank((CharSequence)blueprintKey)) continue;
            displayableBlueprintKeys.add(AbstractPluginSettingsBlueprintStateController.getCompleteKey(webItemModuleDescriptor.getPluginKey(), blueprintKey));
        }
        return displayableBlueprintKeys;
    }

    private static String getCompleteKey(String pluginKey, String blueprintKey) {
        return new ModuleCompleteKey(pluginKey, blueprintKey).getCompleteKey();
    }
}

