/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.api.contextproviders;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.TemplateRendererHelper;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.util.HashMap;
import java.util.Map;

@PublicSpi
public abstract class AbstractBlueprintContextProvider
implements ContextProvider {
    protected TemplateRendererHelper templateRendererHelper;

    @Deprecated
    public AbstractBlueprintContextProvider() {
    }

    public AbstractBlueprintContextProvider(TemplateRendererHelper templateRendererHelper) {
        this.templateRendererHelper = templateRendererHelper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public final Map<String, Object> getContextMap(Map<String, Object> context) {
        return this.updateBlueprintContext(new BlueprintContext(context)).getMap();
    }

    protected abstract BlueprintContext updateBlueprintContext(BlueprintContext var1);

    protected String renderCreateFromTemplateMacro(String contentBlueprintId, String createButtonLabel, String spaceKey, String blueprintModuleCompleteKey) {
        if (this.templateRendererHelper == null) {
            throw new UnsupportedOperationException("Cannot use this method without first specifying a templateRendererHelper.");
        }
        HashMap<String, String> createFromTemplateMacroParams = new HashMap<String, String>();
        createFromTemplateMacroParams.put("contentBlueprintId", contentBlueprintId);
        createFromTemplateMacroParams.put("createButtonLabel", createButtonLabel);
        if (spaceKey != null && !spaceKey.isBlank()) {
            createFromTemplateMacroParams.put("spaceKey", spaceKey);
        }
        createFromTemplateMacroParams.put("contentBlueprintId", contentBlueprintId);
        createFromTemplateMacroParams.put("blueprintModuleCompleteKey", blueprintModuleCompleteKey);
        return this.templateRendererHelper.renderMacroXhtml("create-from-template", createFromTemplateMacroParams);
    }

    protected String renderContentReportTableMacro(String templateLabel, String analyticsKey, String spaceKey, String blankTitle, String blankDescription, String createButtonLabel, String contentBlueprintId, String blueprintModuleCompleteKey) {
        if (this.templateRendererHelper == null) {
            throw new UnsupportedOperationException("Cannot use this method without first specifying a templateRendererHelper.");
        }
        HashMap<String, String> contentReportTableMacroParams = new HashMap<String, String>();
        contentReportTableMacroParams.put("labels", templateLabel);
        contentReportTableMacroParams.put("analyticsKey", analyticsKey);
        contentReportTableMacroParams.put("spaces", spaceKey);
        contentReportTableMacroParams.put("blankTitle", blankTitle);
        contentReportTableMacroParams.put("blankDescription", blankDescription);
        contentReportTableMacroParams.put("createButtonLabel", createButtonLabel);
        contentReportTableMacroParams.put("contentBlueprintId", contentBlueprintId);
        contentReportTableMacroParams.put("blueprintModuleCompleteKey", blueprintModuleCompleteKey);
        return this.templateRendererHelper.renderMacroXhtml("content-report-table", contentReportTableMacroParams);
    }

    public void setTemplateRendererHelper(TemplateRendererHelper templateRendererHelper) {
        this.templateRendererHelper = templateRendererHelper;
    }
}

