/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.contextproviders;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import java.util.Map;

public class QuickCreateUrlContextProvider
implements ContextProvider {
    private final HttpContext httpContext;
    private final ContextPathHolder contextPathHolder;
    private final XsrfTokenGenerator simpleXsrfTokenGenerator;

    public QuickCreateUrlContextProvider(@ComponentImport HttpContext httpContext, ContextPathHolder contextPathHolder, @ComponentImport XsrfTokenGenerator simpleXsrfTokenGenerator) {
        this.httpContext = httpContext;
        this.contextPathHolder = contextPathHolder;
        this.simpleXsrfTokenGenerator = simpleXsrfTokenGenerator;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        UrlBuilder urlBuilder;
        Object renderingQuickURL = context.get("renderingQuickURL");
        if (renderingQuickURL == null || !Boolean.parseBoolean(renderingQuickURL.toString())) {
            return context;
        }
        Space space = (Space)context.get("space");
        if (space != null) {
            urlBuilder = new UrlBuilder(this.contextPathHolder.getContextPath() + "/pages/createpage.action");
            AbstractPage page = (AbstractPage)context.get("page");
            urlBuilder.add("spaceKey", space.getKey());
            if (page != null) {
                urlBuilder.add("fromPageId", page.getId());
            }
        } else {
            urlBuilder = new UrlBuilder(this.contextPathHolder.getContextPath() + "/plugins/createcontent/createpage-defaultspace.action");
        }
        urlBuilder.add("atl_token", this.getAtlToken());
        urlBuilder.add("src", "quick-create");
        context.put("quickUrlHtml", new HtmlFragment((Object)urlBuilder.toUrl()));
        return context;
    }

    private String getAtlToken() {
        return this.simpleXsrfTokenGenerator.getToken(this.httpContext.getActiveRequest(), true);
    }
}

