/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.exceptions;

import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.RestTypedException;
import com.atlassian.confluence.plugins.createcontent.exceptions.ResourceException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionMapper.class);

    public Response toResponse(Exception exception) {
        if (exception instanceof WebApplicationException) {
            log.error(exception.getMessage(), (Throwable)exception);
            return ((WebApplicationException)exception).getResponse();
        }
        if (exception instanceof RestTypedException) {
            RestTypedException restTypedException = (RestTypedException)((Object)exception);
            return ResourceException.makeResponse(exception.getMessage(), (Response.StatusType)Response.Status.BAD_REQUEST, restTypedException.getErrorType(), restTypedException.getErrorData());
        }
        if (exception instanceof ReadOnlyException) {
            return ResourceException.makeResponse(exception.getMessage(), new AdditionalStatus(405, "READ_ONLY", Response.Status.Family.CLIENT_ERROR), ResourceErrorType.ACCESS_MODE, null);
        }
        log.error(exception.getMessage(), (Throwable)exception);
        return ResourceException.makeResponse(exception.getMessage(), (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, ResourceErrorType.UNKNOWN, null);
    }

    record AdditionalStatus(int statusCode, String reasonPhrase, Response.Status.Family family) implements Response.StatusType
    {
        public Response.Status.Family getFamily() {
            return this.family;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }
    }
}

