/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.experimental;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintId;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintInstance;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.content.ContentBlueprintService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/blueprint")
@ExperimentalApi
@PublicApi
public class ExperimentalContentBlueprintResource
extends AbstractRestResource {
    private final ContentBlueprintService contentBlueprintService;

    @Inject
    public ExperimentalContentBlueprintResource(PermissionManager permissionManager, SpaceManager spaceManager, ContentBlueprintService contentBlueprintService, AccessModeService accessModeService) {
        super(permissionManager, spaceManager, accessModeService);
        this.contentBlueprintService = contentBlueprintService;
    }

    @POST
    @Path(value="{blueprintId}/instance")
    @ScopesAllowed(requiredScope={"WRITE"})
    public ContentBlueprintInstance createInstance(ContentBlueprintInstance instance, @PathParam(value="blueprintId") ContentBlueprintId blueprintId, @QueryParam(value="expand") @DefaultValue(value="body.storage,history,space,version,ancestors") String expand) throws ServiceException {
        this.checkNullEntity(instance);
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.contentBlueprintService.createInstance(instance, expansions);
    }
}

