/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.extensions;

import com.atlassian.confluence.plugins.createcontent.extensions.UserBlueprintConfigManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={UserBlueprintConfigManager.class})
public class DefaultUserBlueprintConfigManager
implements UserBlueprintConfigManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserBlueprintConfigManager.class);
    private static final String CREATED_BLUEPRINT_KEYS = "createdBlueprints";
    private static final String SKIP_HOW_TO_USE_BLUEPRINT_KEYS = "skip-how-to-use-blueprint-keys";
    private final UserAccessor userAccessor;

    @Autowired
    public DefaultUserBlueprintConfigManager(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public Set<UUID> getSkipHowToUseKeys(ConfluenceUser user) {
        UserPreferences userPreferences = this.getUserPreferences(user);
        return this.getSkipKeys(userPreferences);
    }

    @Override
    public void setSkipHowToUse(ConfluenceUser user, UUID contentBlueprintId, boolean skip) {
        UserPreferences userPreferences = this.getUserPreferences(user);
        Set<UUID> skipKeys = this.getSkipKeys(userPreferences);
        if (skip) {
            skipKeys.add(contentBlueprintId);
        } else {
            skipKeys.remove(contentBlueprintId);
        }
        String keysStr = StringUtils.join(skipKeys, (String)",");
        try {
            userPreferences.setString(SKIP_HOW_TO_USE_BLUEPRINT_KEYS, keysStr);
        }
        catch (UserPreferences.PreferenceException e) {
            log.warn("Unable to skip how to use blueprint for user: {}", (Object)user);
        }
    }

    @Override
    public boolean isFirstBlueprintOfTypeForUser(UUID id, ConfluenceUser user) {
        UserPreferences userPreferences = this.getUserPreferences(user);
        String blueprintKeys = userPreferences.getString(CREATED_BLUEPRINT_KEYS).orElse(null);
        return blueprintKeys == null || !blueprintKeys.contains(id.toString());
    }

    @Override
    public void setBlueprintCreatedByUser(UUID id, ConfluenceUser user) {
        UserPreferences userPreferences = this.getUserPreferences(user);
        Object blueprintKeys = userPreferences.getString(CREATED_BLUEPRINT_KEYS).orElse(null);
        String idStr = id.toString();
        boolean modified = false;
        if (blueprintKeys == null) {
            blueprintKeys = idStr;
            modified = true;
        }
        if (!((String)blueprintKeys).contains(idStr)) {
            blueprintKeys = (String)blueprintKeys + "," + idStr;
            modified = true;
        }
        if (modified) {
            try {
                userPreferences.setString(CREATED_BLUEPRINT_KEYS, (String)blueprintKeys);
            }
            catch (UserPreferences.PreferenceException e) {
                log.warn("Unable to set createdBlueprints for user: {}", (Object)user);
            }
        }
    }

    public UserPreferences getUserPreferences(ConfluenceUser user) {
        return this.userAccessor.getUserPreferences(user);
    }

    private Set<UUID> getSkipKeys(UserPreferences userPreferences) {
        String keysStr;
        String string = keysStr = userPreferences.getString(SKIP_HOW_TO_USE_BLUEPRINT_KEYS).isPresent() ? (String)userPreferences.getString(SKIP_HOW_TO_USE_BLUEPRINT_KEYS).get() : null;
        if (StringUtils.isBlank(keysStr)) {
            return new HashSet<UUID>();
        }
        String[] split = keysStr.split(",");
        HashSet<UUID> ids = new HashSet<UUID>();
        for (String id : split) {
            ids.add(UUID.fromString(id));
        }
        return ids;
    }
}

