/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.plugins.createcontent.rest.IconUrlProvider;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIconUrlProvider
implements IconUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultIconUrlProvider.class);
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final PluginAccessor pluginAccessor;
    Tika tika;

    @VisibleForTesting
    public DefaultIconUrlProvider(@ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport PluginAccessor pluginAccessor, Tika tika) {
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.pluginAccessor = pluginAccessor;
        this.tika = tika;
    }

    @Autowired
    public DefaultIconUrlProvider(@ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport PluginAccessor pluginAccessor) {
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.pluginAccessor = pluginAccessor;
        this.tika = new Tika();
    }

    @Override
    public String getDefaultIconUrl() {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl("com.atlassian.confluence.plugins.confluence-create-content-plugin:resources", "images/preview-default-template.png", UrlMode.AUTO);
    }

    @Override
    public String getIconURL(WebItemModuleDescriptor webItemModuleDescriptor) {
        ResourceLocation resourceLocation = webItemModuleDescriptor.getResourceLocation("download", "icon");
        if (resourceLocation == null) {
            return this.getDefaultIconUrl();
        }
        String iconFileName = resourceLocation.getName();
        if (!StringUtils.isBlank((CharSequence)iconFileName) && this.isValidIcon(webItemModuleDescriptor, resourceLocation)) {
            String moduleKey = webItemModuleDescriptor.getCompleteKey();
            return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleKey, iconFileName, UrlMode.AUTO);
        }
        return this.getDefaultIconUrl();
    }

    private boolean isValidIcon(WebItemModuleDescriptor webItemModuleDescriptor, ResourceLocation resourceLocation) {
        boolean bl;
        block10: {
            String location = resourceLocation.getLocation();
            String pluginKey = webItemModuleDescriptor.getPluginKey();
            Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
            if (plugin == null) {
                log.error("Cannot find plugin {}", (Object)pluginKey);
                return false;
            }
            URL resource = plugin.getResource(location);
            if (resource == null) {
                log.warn("Cannot find resource at location {} in plugin {}", (Object)location, (Object)pluginKey);
                return false;
            }
            InputStream stream = resource.openStream();
            try {
                String mimeType = this.tika.detect(stream);
                boolean bl2 = bl = mimeType != null && mimeType.startsWith("image");
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Couldn't verify icon at {}", (Object)resource.getPath());
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }
}

